/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <locale.h>

#include "config.h"
#include "../sys/sys.h"
#include "gfx.h"

#define TEST_WIDTH 640
#define TEST_HEIGHT 480
#define TEST_DELAY 10
#define TEST_DURATION_SETUP 1000
#define TEST_DURATION_BACKGROUND 3000

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"gfx-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"gfx-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"gfx-test",_("tests in \"%s\" failed"),__FUNCTION__); }

static void
resize_callback (int width, int height, int fullscreen)
{
  lw6sys_log (LW6SYS_LOG_DEBUG, "gfx-test",
	      _("resize callback called %dx%d fullscreen=%d"), width,
	      height, fullscreen);
}

static int
test_init (LW6GFX_BACKEND * backend)
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    int ticks;

    ret = ret
      && lw6gfx_init (backend, TEST_WIDTH, TEST_HEIGHT, 0, resize_callback,
		      0);
    ticks = lw6gfx_get_ticks (backend);
    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_SETUP
	   && !lw6gfx_poll_quit (backend))
      {
	lw6gfx_delay (backend, TEST_DELAY);
      }
  }

  FUNCTION_END;
  return ret;
}

static int
test_background (LW6GFX_BACKEND * backend)
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    int ticks;

    ticks = lw6gfx_get_ticks (backend);
    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_BACKGROUND
	   && !lw6gfx_poll_quit (backend))
      {
	lw6gfx_prepare_buffer (backend);
	lw6gfx_display_background (backend, "water");
	lw6gfx_swap_buffers (backend);
	lw6gfx_delay (backend, TEST_DELAY);
      }
    ticks = lw6gfx_get_ticks (backend);
    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_BACKGROUND
	   && !lw6gfx_poll_quit (backend))
      {
	lw6gfx_prepare_buffer (backend);
	lw6gfx_display_background (backend, "air");
	lw6gfx_swap_buffers (backend);
	lw6gfx_delay (backend, TEST_DELAY);
      }
    ticks = lw6gfx_get_ticks (backend);
    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_BACKGROUND
	   && !lw6gfx_poll_quit (backend))
      {
	lw6gfx_prepare_buffer (backend);
	lw6gfx_display_background (backend, "earth");
	lw6gfx_swap_buffers (backend);
	lw6gfx_delay (backend, TEST_DELAY);
      }
    ticks = lw6gfx_get_ticks (backend);
    while (lw6gfx_get_ticks (backend) < ticks + TEST_DURATION_BACKGROUND
	   && !lw6gfx_poll_quit (backend))
      {
	lw6gfx_prepare_buffer (backend);
	lw6gfx_display_background (backend, "fire");
	lw6gfx_swap_buffers (backend);
	lw6gfx_delay (backend, TEST_DELAY);
      }
  }

  FUNCTION_END;
  return ret;
}

static int
test_quit (LW6GFX_BACKEND * backend)
{
  int ret = 1;
  FUNCTION_BEGIN;

  lw6gfx_quit (backend);

  FUNCTION_END;
  return ret;
}

int
main (int argc, char *argv[])
{
  int ret = 1;
  LW6GFX_BACKEND *backend;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  backend = lw6gfx_create_backend ("gl");
  ret = test_init (backend) && test_background (backend)
    && test_quit (backend);
  lw6gfx_destroy_backend (backend);

  ret = ret && lw6sys_check_malloc_free_count ();

  return (!ret);
}
