/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_H
#define LIQUIDWAR6GFX_H

#include "../lw6-common.h"

#include "../sys/sys.h"
#include "../dyn/dyn.h"
#include "../map/map.h"
#include "../ker/ker.h"

#define LW6GFX_NB_CURSOR_SHAPES LW6OPT_MAX_NB_TEAMS
typedef enum LW6GFX_CURSOR_SHAPE_ENUM
{
  LW6GFX_CURSOR_SHAPE_CIRCLE = 0,
  LW6GFX_CURSOR_SHAPE_SQUARE = 1,
  LW6GFX_CURSOR_SHAPE_TRIANGLE = 2,
  LW6GFX_CURSOR_SHAPE_STAR = 3,
  LW6GFX_CURSOR_SHAPE_RECTANGLE = 4,
  LW6GFX_CURSOR_SHAPE_RHOMBUS = 5,
  LW6GFX_CURSOR_SHAPE_PARALLELOGRAM = 6,
  LW6GFX_CURSOR_SHAPE_PENTAGON = 7,
  LW6GFX_CURSOR_SHAPE_HEXAGON = 8,
  LW6GFX_CURSOR_SHAPE_OCTOGON = 9
}
LW6GFX_CURSOR_SHAPE;

#define LW6GFX_NB_MOUSE_BUTTONS 2
typedef enum LW6GFX_MOUSE_BUTTON_ENUM
{
  LW6GFX_MOUSE_BUTTON_LEFT = 0,
  LW6GFX_MOUSE_BUTTON_RIGHT = 1
}
LW6GFX_MOUSE_BUTTON;

typedef struct LW6GFX_TEAM_LOOK_STRUCT
{
  int color_id;
  int cursor_shape_id;
}
LW6GFX_TEAM_LOOK;

typedef struct LW6GFX_GAME_LOOK_STRUCT
{
  int id;
  LW6GFX_TEAM_LOOK teams[LW6OPT_MAX_NB_TEAMS];
}
LW6GFX_GAME_LOOK;

typedef struct LW6GFX_KEYPRESS_STRUCT
{
  int sym;
  int unicode;
  char *label;
}
LW6GFX_KEYPRESS;

#define LW6GFX_NB_MENUITEM_TYPES 4
typedef enum LW6GFX_MENUITEM_TYPE_ENUM
{
  LW6GFX_MENUITEM_NONE = 0,
  LW6GFX_MENUITEM_BUTTON = 1,
  LW6GFX_MENUITEM_EDIT = 2,
  LW6GFX_MENUITEM_SLIDER = 3
}
LW6GFX_MENUITEM_TYPE;

typedef struct LW6GFX_MENUITEM_STRUCT
{
  char *label;
  LW6GFX_MENUITEM_TYPE type;
  int enabled;
  int value;
  int selected_char;
}
LW6GFX_MENUITEM;

#define LW6GFX_NB_MENU_TYPES 3
typedef enum LW6GFX_MENU_TYPE_ENUM
{
  LW6GFX_MENU_NONE = 0,
  LW6GFX_MENU_DEFAULT = 1,
  LW6GFX_MENU_GAME = 2
}
LW6GFX_MENU_TYPE;

typedef struct LW6GFX_MENU_STRUCT
{
  char *id;
  char *label;
  LW6GFX_MENU_TYPE type;
  int selected_item;
  int nb_items;
  LW6GFX_MENUITEM **items;
}
LW6GFX_MENU;

typedef struct LW6GFX_MENU_STATE_STRUCT
{
  int first_item_displayed;
  int nb_items_displayed;
}
LW6GFX_MENU_STATE;

#define LW6GFX_NB_HUD_STEPS 2
typedef enum LW6GFX_HUD_STEP_ENUM
{
  LW6GFX_HUD_STEP_BG = 0,
  LW6GFX_HUD_STEP_FG = 1
}
LW6GFX_HUD_STEP;

typedef struct LW6GFX_BACKEND_STRUCT
{
  LW6DYN_DL_HANDLE *dl_handle;
  void *gfx_context;

  void (*display_background) (void *gfx_context, char *skin);
  void (*display_hud) (void *gfx_context, LW6KER_GAME_STATE * game_state,
		       LW6GFX_HUD_STEP step, char *skin);
  void (*display_hud_preview) (void *gfx_context, LW6GFX_HUD_STEP step,
			       char *skin);
  int (*poll_keypress) (void *gfx_context, LW6GFX_KEYPRESS * keypress);
  int (*is_key_esc) (void *gfx_context, int keysym);
  int (*is_key_up) (void *gfx_context, int keysym);
  int (*is_key_down) (void *gfx_context, int keysym);
  int (*is_key_left) (void *gfx_context, int keysym);
  int (*is_key_right) (void *gfx_context, int keysym);
  int (*is_key_enter) (void *gfx_context, int keysym);
  int (*is_key_del) (void *gfx_context, int keysym);
  int (*is_key_backspace) (void *gfx_context, int keysym);
  int (*is_key_help) (void *gfx_context, int keysym);
  int (*is_key_quit) (void *gfx_context, int keysym);
  int (*poll_quit) (void *gfx_context);
  void (*send_quit) (void *gfx_context);
  int (*get_key_state) (void *gfx_context, int keysym);
  int (*poll_mouse_move) (void *gfx_context, int *x, int *y);
  int (*poll_mouse_button) (void *gfx_context, int button);
  void (*get_mouse_state) (void *gfx_context, int *x, int *y,
			   int *button_left, int *button_right);
  void (*display_sysinfo) (void *gfx_context, int fps, int rps, int bytes_in,
			   int bytes_out);
  void (*display_log) (void *gfx_context, char **log);
  void (*display_time) (void *gfx_context, long long seconds);
  void (*display_version) (void *gfx_context);
  void (*display_map_preview) (void *gfx_context, LW6MAP_MAP * map,
			       char *skin);
  void (*display_map_zones) (void *gfx_context, LW6MAP_MAP * map,
			     LW6KER_MAP_STRUCT * map_struct, char *skin);
  void (*display_map_gradient) (void *gfx_context, LW6MAP_MAP * map,
				LW6KER_MAP_STATE * map_state, int team_id,
				char *skin);
  void (*display_game) (void *gfx_context, LW6MAP_MAP * map,
			LW6KER_GAME_STATE * game_state,
			LW6GFX_GAME_LOOK * game_look, char *skin);
  void (*pick_map_coord) (void *gfx_context, int *map_x, int *map_y,
			  LW6MAP_MAP * map, LW6KER_GAME_STATE * game_state,
			  int screen_x, int screen_y, char *skin);
  void (*display_menu) (void *gfx_context, LW6GFX_MENU * menu, char *skin);
  int (*pick_menuitem) (void *gfx_context, LW6GFX_MENU * menu, int screen_x,
			int screen_y, char *skin);
  void (*prepare_buffer) (void *gfx_context);
  void (*swap_buffers) (void *gfx_context);
  void *(*init) (int width, int height, int fullscreen,
		 void (*resize_callback) (int width,
					  int height, int fullscreen),
		 int ticks);
  int (*set_video_mode) (void *gfx_context, int width, int height,
			 int fullscreen,
			 void (*resize_callback) (int width,
						  int height,
						  int fullscreen));
  void (*quit) (void *gfx_context);
  void (*delay) (void *gfx_context, int ms);
  int (*get_ticks) (void *gfx_context);
}
LW6GFX_BACKEND;

/*
 * In api.c
 */
extern void lw6gfx_display_background (LW6GFX_BACKEND * backend, char *skin);
extern void lw6gfx_display_hud (LW6GFX_BACKEND * backend,
				LW6KER_GAME_STATE * game_state,
				LW6GFX_HUD_STEP step, char *skin);
extern void lw6gfx_display_hud_preview (LW6GFX_BACKEND * backend,
					LW6GFX_HUD_STEP step, char *skin);
extern int lw6gfx_poll_keypress (LW6GFX_BACKEND * backend,
				 LW6GFX_KEYPRESS * keypress);
extern int lw6gfx_is_key_esc (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_up (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_down (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_left (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_right (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_enter (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_del (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_backspace (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_help (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_is_key_quit (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_poll_quit (LW6GFX_BACKEND * backend);
extern void lw6gfx_send_quit (LW6GFX_BACKEND * backend);
extern int lw6gfx_get_key_state (LW6GFX_BACKEND * backend, int keysym);
extern int lw6gfx_poll_mouse_move (LW6GFX_BACKEND * backend, int *x, int *y);
extern int lw6gfx_poll_mouse_button (LW6GFX_BACKEND * backend, int button);
extern void lw6gfx_get_mouse_state (LW6GFX_BACKEND * backend, int *x, int *y,
				    int *button_left, int *button_right);
extern void lw6gfx_display_sysinfo (LW6GFX_BACKEND * backend, int fps,
				    int rps, int bytes_in, int bytes_out);
extern void lw6gfx_display_log (LW6GFX_BACKEND * backend, char **log);
extern void lw6gfx_display_time (LW6GFX_BACKEND * backend, long long seconds);
extern void lw6gfx_display_version (LW6GFX_BACKEND * backend);
extern void lw6gfx_display_map_preview (LW6GFX_BACKEND * backend,
					LW6MAP_MAP * map, char *skin);
extern void lw6gfx_display_map_zones (LW6GFX_BACKEND * backend,
				      LW6MAP_MAP * map,
				      LW6KER_MAP_STRUCT * map_struct,
				      char *skin);
extern void lw6gfx_display_map_gradient (LW6GFX_BACKEND * backend,
					 LW6MAP_MAP * map,
					 LW6KER_MAP_STATE * map_state,
					 int team_id, char *skin);
extern void lw6gfx_display_game (LW6GFX_BACKEND * backend, LW6MAP_MAP * map,
				 LW6KER_GAME_STATE * game_state,
				 LW6GFX_GAME_LOOK * game_look, char *skin);
extern void lw6gfx_pick_map_coord (LW6GFX_BACKEND * backend, int *map_x,
				   int *map_y, LW6MAP_MAP * map,
				   LW6KER_GAME_STATE * game_state,
				   int screen_x, int screen_y, char *skin);
extern void lw6gfx_display_menu (LW6GFX_BACKEND * backend, LW6GFX_MENU * menu,
				 char *skin);
extern int lw6gfx_pick_menuitem (LW6GFX_BACKEND * backend, LW6GFX_MENU * menu,
				 int screen_x, int screen_y, char *skin);
extern void lw6gfx_prepare_buffer (LW6GFX_BACKEND * backend);
extern void lw6gfx_swap_buffers (LW6GFX_BACKEND * backend);
extern int lw6gfx_init (LW6GFX_BACKEND * backend, int width,
			int height, int fullscreen,
			void (*resize_callback) (int width,
						 int height, int fullscreen),
			int ticks);
extern int lw6gfx_set_video_mode (LW6GFX_BACKEND * backend, int width,
				  int height, int fullscreen,
				  void (*resize_callback) (int width,
							   int height,
							   int fullscreen));
extern void lw6gfx_quit (LW6GFX_BACKEND * backend);
extern void lw6gfx_delay (LW6GFX_BACKEND * backend, int ms);
extern int lw6gfx_get_ticks (LW6GFX_BACKEND * backend);

/*
 * In register.c
 */
extern LW6SYS_ASSOC *lw6gfx_get_backends ();
extern LW6GFX_BACKEND *lw6gfx_create_backend (char *name);
extern void lw6gfx_destroy_backend (LW6GFX_BACKEND * backend);

/*
 * In gamelook.c
 */
extern LW6GFX_GAME_LOOK *lw6gfx_game_look_new ();
extern void lw6gfx_game_look_free (LW6GFX_GAME_LOOK * game_look);
extern int lw6gfx_game_look_memory_footprint (LW6GFX_GAME_LOOK * game_look);
extern char *lw6gfx_game_look_repr (LW6GFX_GAME_LOOK * game_look);

/*
 * In menu.c
 */
extern LW6GFX_MENU *lw6gfx_menu_new (char *id, char *label,
				     LW6GFX_MENU_TYPE type,
				     int selected_items, int nb_items);
extern void lw6gfx_menu_free (LW6GFX_MENU * menu);
void
  extern lw6gfx_menu_set_item (LW6GFX_MENU * menu, int i,
			       LW6GFX_MENUITEM * menuitem);

/*
 * In menuitem.c
 */
extern LW6GFX_MENUITEM *lw6gfx_menuitem_new (char *label,
					     LW6GFX_MENUITEM_TYPE type,
					     int enabled, int value,
					     int selected_char);
extern void lw6gfx_menuitem_free (LW6GFX_MENUITEM * menuitem);

/*
 * In menustate.c
 */
extern LW6GFX_MENU_STATE *lw6gfx_menu_state_new ();
extern void lw6gfx_menu_state_free (LW6GFX_MENU_STATE * menu_state);
extern void lw6gfx_menu_state_update (LW6GFX_MENU_STATE * menu_state,
				      LW6GFX_MENU * menu,
				      int max_displayed_items);

#endif
