/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "gl-hud.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING, "gfx-mod-gl",
	      _("hud backend function \"%s\" is not defined"));
}

int
mod_gl_hud_init (MOD_GL_UTILS_CONTEXT * utils_context,
		 MOD_GL_HUD_BACKEND * backend)
{
  if (backend->init)
    {
      backend->hud_context = backend->init (utils_context);
    }
  else
    {
      warning ("hud_init");
    }

  return backend->hud_context ? 1 : 0;
}

void
mod_gl_hud_quit (MOD_GL_UTILS_CONTEXT * utils_context,
		 MOD_GL_HUD_BACKEND * backend)
{
  if (backend->quit)
    {
      backend->quit (utils_context, backend->hud_context);
    }
  else
    {
      warning ("hud_quit");
    }
}

void
mod_gl_hud_display (MOD_GL_UTILS_CONTEXT * utils_context,
		    MOD_GL_HUD_BACKEND * backend,
		    LW6KER_GAME_STATE * game_state, LW6GFX_HUD_STEP step)
{
  if (backend->display)
    {
      backend->display (utils_context, backend->hud_context, game_state,
			step);
    }
  else
    {
      warning ("hud_display");
    }
}

void
mod_gl_hud_display_preview (MOD_GL_UTILS_CONTEXT * utils_context,
			    MOD_GL_HUD_BACKEND * backend,
			    LW6GFX_HUD_STEP step)
{
  if (backend->display_preview)
    {
      backend->display_preview (utils_context, backend->hud_context, step);
    }
  else
    {
      warning ("hud_display_preview");
    }
}
