/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_MENU_CYLINDER_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_MENU_CYLINDER_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "gl-cylinder.h"

typedef struct _MOD_GL_MENU_CYLINDER_CONST_DATA_STRUCT
{
  float radius1;
  float between1;
  float height;
  int slices1;
  int slices_min;
  int stacks;
  float oscil_range1;
  int oscil_period;
  float rotate_offset;
}
_MOD_GL_MENU_CYLINDER_CONST_DATA;

typedef struct _MOD_GL_MENU_CYLINDER_CONTEXT_STRUCT
{
  _MOD_GL_MENU_CYLINDER_CONST_DATA const_data;
  LW6SYS_ASSOC *menu_states;
}
_MOD_GL_MENU_CYLINDER_CONTEXT;

/*
 * In display.c
 */
extern void _mod_gl_menu_cylinder_display (MOD_GL_UTILS_CONTEXT *
					   utils_context,
					   _MOD_GL_MENU_CYLINDER_CONTEXT *
					   cylinder_context,
					   LW6GFX_MENU * menu);

/*
 * In data.c
 */
extern int _mod_gl_menu_cylinder_load_data (MOD_GL_UTILS_CONTEXT *
					    utils_context,
					    _MOD_GL_MENU_CYLINDER_CONTEXT *
					    cylinder_context);
extern void _mod_gl_menu_cylinder_unload_data (MOD_GL_UTILS_CONTEXT *
					       utils_context,
					       _MOD_GL_MENU_CYLINDER_CONTEXT *
					       cylinder_context);

/*
 * In draw.c
 */
void _mod_gl_menu_cylinder_draw_cylinder (MOD_GL_UTILS_CONTEXT *
					  utils_context,
					  _MOD_GL_MENU_CYLINDER_CONTEXT *
					  cylinder_context, GLenum mode,
					  int i, int n, float ratio);

/*
 * In pick.c
 */
int
_mod_gl_menu_cylinder_pick_item (MOD_GL_UTILS_CONTEXT * utils_context,
				 _MOD_GL_MENU_CYLINDER_CONTEXT *
				 cylinder_context, LW6GFX_MENU * menu,
				 int screen_x, int screen_y);
/*
 * In setup.c
 */
extern _MOD_GL_MENU_CYLINDER_CONTEXT
  * _mod_gl_menu_cylinder_init (MOD_GL_UTILS_CONTEXT * utils_context);
extern void _mod_gl_menu_cylinder_quit (MOD_GL_UTILS_CONTEXT * utils_context,
					_MOD_GL_MENU_CYLINDER_CONTEXT *
					cylinder_context);

#endif
