/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

void
mod_gl_utils_display_sysinfo (MOD_GL_UTILS_CONTEXT * context, int fps,
			      int rps, int bytes_in, int bytes_out)
{
  char *text_list[5];
  char *str_fps;
  char *str_rps;
  char *str_kb_in;
  char *str_kb_out;

  str_fps = lw6sys_new_sprintf (_("%d fps"), fps);
  if (str_fps)
    {
      text_list[0] = str_fps;
      str_rps = lw6sys_new_sprintf (_("%d rps"), rps);
      if (str_rps)
	{
	  text_list[1] = str_rps;
	  str_kb_in =
	    lw6sys_new_sprintf (_("%0.2f kb/s in"),
				((float) bytes_in / 1024.0));
	  if (str_kb_in)
	    {
	      text_list[2] = str_kb_in;
	      str_kb_out =
		lw6sys_new_sprintf (_("%0.2f kb/s out"),
				    ((float) bytes_out / 1024.0));
	      if (str_kb_out)
		{
		  text_list[3] = str_kb_out;
		  text_list[4] = NULL;

		  mod_gl_utils_draw_system_text_top_right (context,
							   text_list);

		  LW6SYS_FREE (str_kb_out);
		}
	      LW6SYS_FREE (str_kb_in);
	    }
	  LW6SYS_FREE (str_rps);
	}
      LW6SYS_FREE (str_fps);
    }
}

void
mod_gl_display_sysinfo (void *context, int bps, int rps, int bytes_in,
			int bytes_out)
{
  mod_gl_utils_display_sysinfo ((MOD_GL_UTILS_CONTEXT *) context, bps, rps,
				bytes_in, bytes_out);
}

void
mod_gl_utils_display_log (MOD_GL_UTILS_CONTEXT * context, char **log)
{
  mod_gl_utils_draw_system_text_bottom_left (context, log);
}

void
mod_gl_display_log (void *context, char **log)
{
  mod_gl_utils_display_log ((MOD_GL_UTILS_CONTEXT *) context, log);
}

void
mod_gl_utils_display_time (MOD_GL_UTILS_CONTEXT * context, long long seconds)
{
  char *text_list[2];
  char time_str[100];
  time_t secs;
  struct tm tm;

  secs = (time_t) seconds;
  memset (&tm, 0, sizeof (tm));
  localtime_r (&secs, &tm);
  if (strftime (time_str, sizeof (time_str), "%H:%M:%S", &tm))
    {
      time_str[sizeof (time_str) - 1] = '\0';

      text_list[0] = time_str;
      text_list[1] = NULL;
      mod_gl_utils_draw_system_text_top_left (context, text_list);
    }
}

void
mod_gl_display_time (void *context, long long seconds)
{
  mod_gl_utils_display_time ((MOD_GL_UTILS_CONTEXT *) context, seconds);
}

void
mod_gl_utils_display_version (MOD_GL_UTILS_CONTEXT * context)
{
  char *text_list[3];

  text_list[0] = _("http://www.gnu.org/software/liquidwar6/");
  text_list[1] = NULL;
  mod_gl_utils_draw_system_text_bottom_right (context, text_list);
}

void
mod_gl_display_version (void *context)
{
  mod_gl_utils_display_version ((MOD_GL_UTILS_CONTEXT *) context);
}
