/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <math.h>

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

/*
 * Very slow, we don't care, for debugging only.
 */
SDL_Surface *
mod_gl_utils_create_zones_surface (MOD_GL_UTILS_CONTEXT * utils_context,
				   LW6KER_MAP_STRUCT * map_struct)
{
  SDL_Surface *zones_surface;
  LW6SYS_COLOR_F color;

  zones_surface =
    mod_gl_utils_create_surface (utils_context, map_struct->shape.w,
				 map_struct->shape.h);
  if (zones_surface)
    {
      int i;
      float grey;
      LW6KER_ZONE_STRUCT *zone;
      int log_base;

      log_base = map_struct->max_zone_size;
      if (log_base <= 1)
	{
	  log_base = 2;
	}

      for (i = 0; i < map_struct->nb_zones; ++i)
	{
	  zone = &map_struct->zones[i];
	  grey = log (zone->size) / log (log_base);

	  color.r = color.g = color.b = grey;
	  color.a = utils_context->const_data.gradient_opacity;

	  mod_gl_utils_draw_rectfill (zones_surface, zone->pos.x, zone->pos.y,
				      zone->pos.x + zone->size - 1,
				      zone->pos.y + zone->size - 1,
				      lw6sys_color_f_to_i (&color));
	}
    }

  return (zones_surface);
}
