/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_VIEW_FLAT_H
#define LIQUIDWAR6GFX_MOD_GL_VIEW_FLAT_H

#include "../../../gfx.h"
#include "../../../../map/map.h"
#include "../../gl-utils/gl-utils.h"
#include "../gl-view.h"

extern MOD_GL_VIEW_BACKEND
  * mod_gl_view_flat_create_backend (MOD_GL_UTILS_CONTEXT * utils_context);

/*
 * In display.c
 */
extern void mod_gl_view_flat_display_preview (MOD_GL_UTILS_CONTEXT *
					      utils_context,
					      void *flat_context,
					      LW6MAP_MAP * map);
extern void mod_gl_view_flat_display_zones (MOD_GL_UTILS_CONTEXT *
					    utils_context,
					    void *flat_context,
					    LW6MAP_MAP * map,
					    LW6KER_MAP_STRUCT * map_struct);
extern void mod_gl_view_flat_display_gradient (MOD_GL_UTILS_CONTEXT *
					       utils_context,
					       void *flat_context,
					       LW6MAP_MAP * map,
					       LW6KER_MAP_STATE * map_state,
					       int team_id);
extern void mod_gl_view_flat_display_game (MOD_GL_UTILS_CONTEXT *
					   utils_context,
					   void *flat_context,
					   LW6MAP_MAP * map,
					   LW6KER_GAME_STATE * game_state,
					   LW6GFX_GAME_LOOK * game_look);
/*
 * in pick.c
 */
extern void mod_gl_view_flat_pick_map_coord (MOD_GL_UTILS_CONTEXT *
					     utils_context,
					     void *flat_context,
					     int *map_x,
					     int *map_y,
					     LW6MAP_MAP * map,
					     LW6KER_GAME_STATE * game_state,
					     int screen_x, int screen_y);

/*
 * In setup.c
 */
extern void *mod_gl_view_flat_init (MOD_GL_UTILS_CONTEXT * utils_context);
extern void mod_gl_view_flat_quit (MOD_GL_UTILS_CONTEXT * utils_context,
				   void *flat_context);

#endif
