/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_VIEW_H
#define LIQUIDWAR6GFX_MOD_GL_VIEW_H

#include <ltdl.h>

#include "../../../sys/sys.h"
#include "../../../map/map.h"
#include "gl-view.h"
#include "../mod-gl.h"
#include "../gl-utils/gl-utils.h"

typedef struct MOD_GL_VIEW_BACKEND_STRUCT
{
  void *view_context;
  char *backend_name;

  void *(*init) (MOD_GL_UTILS_CONTEXT * utils_context);
  void (*quit) (MOD_GL_UTILS_CONTEXT * utils_context, void *view_context);
  void (*display_preview) (MOD_GL_UTILS_CONTEXT * utils_context,
			   void *view_context, LW6MAP_MAP * map);
  void (*display_zones) (MOD_GL_UTILS_CONTEXT * utils_context,
			 void *view_context, LW6MAP_MAP * map,
			 LW6KER_MAP_STRUCT * map_struct);
  void (*display_gradient) (MOD_GL_UTILS_CONTEXT * utils_context,
			    void *view_context, LW6MAP_MAP * map,
			    LW6KER_MAP_STATE * map_state, int team_id);
  void (*display_game) (MOD_GL_UTILS_CONTEXT * utils_context,
			void *view_context, LW6MAP_MAP * map,
			LW6KER_GAME_STATE * game_state,
			LW6GFX_GAME_LOOK * game_look);
  void (*pick_map_coord) (MOD_GL_UTILS_CONTEXT * utils_context,
			  void *view_context, int *map_x, int *map_y,
			  LW6MAP_MAP * map, LW6KER_GAME_STATE * game_state,
			  int screen_x, int screen_y);
}
MOD_GL_VIEW_BACKEND;

/*
 * In api.c
 */
extern int mod_gl_view_init (MOD_GL_UTILS_CONTEXT * utils_context,
			     MOD_GL_VIEW_BACKEND * backend);
extern void mod_gl_view_quit (MOD_GL_UTILS_CONTEXT * utils_context,
			      MOD_GL_VIEW_BACKEND * backend);
extern void mod_gl_view_display_preview (MOD_GL_UTILS_CONTEXT *
					 utils_context,
					 MOD_GL_VIEW_BACKEND * backend,
					 LW6MAP_MAP * map);
extern void mod_gl_view_display_zones (MOD_GL_UTILS_CONTEXT *
				       utils_context,
				       MOD_GL_VIEW_BACKEND * backend,
				       LW6MAP_MAP * map,
				       LW6KER_MAP_STRUCT * map_struct);
extern void mod_gl_view_display_gradient (MOD_GL_UTILS_CONTEXT *
					  utils_context,
					  MOD_GL_VIEW_BACKEND * backend,
					  LW6MAP_MAP * map,
					  LW6KER_MAP_STATE * map_state,
					  int team_id);
extern void mod_gl_view_display_game (MOD_GL_UTILS_CONTEXT *
				      utils_context,
				      MOD_GL_VIEW_BACKEND * backend,
				      LW6MAP_MAP * map,
				      LW6KER_GAME_STATE * game_state,
				      LW6GFX_GAME_LOOK * game_look);
extern void mod_gl_view_pick_map_coord (MOD_GL_UTILS_CONTEXT * utils_context,
					MOD_GL_VIEW_BACKEND * backend,
					int *map_x, int *map_y,
					LW6MAP_MAP * map,
					LW6KER_GAME_STATE * game_state,
					int screen_x, int screen_y);

/*
 * In backend.c
 */
extern MOD_GL_VIEW_BACKEND *mod_gl_view_create_backend (MOD_GL_UTILS_CONTEXT
							* utils_context,
							char *name);
extern void mod_gl_view_destroy_backend (MOD_GL_UTILS_CONTEXT *
					 utils_context,
					 MOD_GL_VIEW_BACKEND * backend);

#endif
