/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "ker.h"
#include "ker-internal.h"

LW6SYS_BOOL
_lw6ker_cursor_init (LW6KER_CURSOR * cursor, LW6SYS_XY pos)
{
  LW6SYS_BOOL ret = 0;

  cursor->pos = pos;
  cursor->last_applied_pos = pos;
  cursor->pot_offset = 0;

  ret = 1;			// never fails

  return ret;
}

void
lw6ker_cursor_clear (LW6KER_CURSOR * cursor)
{
  memset (cursor, 0, sizeof (LW6KER_CURSOR));
}

void
_lw6ker_cursor_update_checksum (LW6KER_CURSOR * cursor,
				LW6SYS_UINT32 * checksum)
{
  lw6sys_checksum_update_xy (checksum, &(cursor->pos));
  lw6sys_checksum_update_xy (checksum, &(cursor->last_applied_pos));
  lw6sys_checksum_update_int32 (checksum, cursor->pot_offset);
}

void
_lw6ker_cursor_update_last_applied (LW6KER_CURSOR * cursor)
{
  cursor->last_applied_pos = cursor->pos;
}

/*
 * Simple wrapper to be sure to check bounds before affecting
 * values to a cursor.
 */
LW6SYS_BOOL
lw6ker_cursor_set (LW6KER_CURSOR * cursor, LW6SYS_INT32 x, LW6SYS_INT32 y,
		   LW6SYS_INT32 pot_offset, LW6KER_MAP_STRUCT * map_struct,
		   LW6SYS_INT32 max_cursor_pot_offset)
{
  LW6SYS_BOOL ret = 1;

  if (x >= 0 && x < map_struct->shape.w)
    {
      cursor->pos.x = x;
    }
  else
    {
      ret = 0;
    }

  if (y >= 0 && y < map_struct->shape.h)
    {
      cursor->pos.y = y;
    }
  else
    {
      ret = 0;
    }

  pot_offset = lw6sys_min (pot_offset, max_cursor_pot_offset);
  pot_offset = lw6sys_max (pot_offset, 0);
  cursor->pot_offset = pot_offset;

  return ret;
}
