/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "config.h"
#include "map.h"
#include "map-internal.h"

static char *
extract_title_from_dirname (char *dirname)
{
  char *copy = NULL;
  char *title = NULL;
  char *begin = NULL;
  char *end = NULL;

  copy = lw6sys_str_copy (dirname);
  if (copy)
    {
      end = strrchr (copy, '/');
      if (end)
	{
	  (*end) = '\0';
	  begin = strrchr (copy, '/');
	  if (!begin)
	    {
	      begin = copy;
	    }

	  if (begin && begin < end)
	    {
	      title = lw6sys_str_copy (begin + 1);
	    }
	}
      LW6SYS_FREE (copy);
    }

  if (!title)
    {
      title = lw6sys_str_copy (_("no title for this map"));
    }

  if (!title)
    {
      lw6sys_log (LW6SYS_LOG_ERROR, "map",
		  _("unable to handle map title, running out of memory?"));
    }

  return title;
}

static char *
read_readme (char *dirname)
{
  char *buf = NULL;
  char *readme = NULL;

  buf = lw6sys_str_concat (dirname, "README");
  if (buf)
    {
      readme = lw6sys_read_file_content (buf);
      LW6SYS_FREE (buf);
    }

  if (!readme)
    {
      readme = lw6sys_str_copy (_("no README for this map"));
    }

  if (!readme)
    {
      lw6sys_log (LW6SYS_LOG_ERROR, "map",
		  _
		  ("unable to handle map README file, running out of memory?"));
    }

  return readme;
}

/*
 * Read the metadata associated to a map. Pointer to metadata must be valid,
 * it's modified in-place.
 */
int
lw6map_metadata_read (LW6MAP_METADATA * metadata, char *dirname)
{
  int ret = 0;

  lw6map_metadata_clear (metadata);

  metadata->title = extract_title_from_dirname (dirname);
  metadata->readme = read_readme (dirname);

  ret = (metadata->title && metadata->readme);

  return ret;
}

/*
 * Clears a metadata.
 */
void
lw6map_metadata_clear (LW6MAP_METADATA * metadata)
{
  if (metadata)
    {
      if (metadata->title)
	{
	  LW6SYS_FREE (metadata->title);
	}
      if (metadata->readme)
	{
	  LW6SYS_FREE (metadata->readme);
	}
      memset (metadata, 0, sizeof (LW6MAP_METADATA));

      /*
       * We don't free the metadata pointer itself, this
       * is a "clear" function, not a "free".
       */
    }
}
