/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "map.h"
#include "../cfg/cfg.h"
#include "map-internal.h"

/*
 * One could wonder why this is not in the "opt" module. Basically,
 * doing so would tie the "opt" module to some XML library, and since
 * the "ker" module requires it, we would end up with "ker" requiring
 * an XML library, which is certainly not want we want. Actually
 * "opt" is only here to avoid "ker" depending directly on "map" and
 * its dependencies.
 */

#define OPTIONS_XML_FILE "options.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  LW6OPT_STATIC *options_data;
  int int_value;

  options_data = (LW6OPT_STATIC *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, key, &int_value);
      lw6opt_static_set_int (options_data, key, int_value);
    }

  if (!strcmp (element, "bool"))
    {
      lw6cfg_read_xml_bool (key, value, key, &int_value);
      lw6opt_static_set_bool (options_data, key, int_value);
    }

  if (!strcmp (element, "float"))
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "map",
		  _
		  ("map options should not use floats, XML entry %s=%s is not correct"),
		  key, value);
    }

  if (!strcmp (element, "string"))
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "map",
		  _
		  ("map options should not use strings, XML entry %s=%s is not correct"),
		  key, value);
    }
}

/*
 * Read the options associated to a map. Pointer to options must be valid,
 * it's modified in-place.
 */
int
lw6map_options_read (LW6OPT_STATIC * options, char *dirname)
{
  int ret = 0;
  char *buf = NULL;

  buf = lw6sys_str_concat (dirname, OPTIONS_XML_FILE);

  if (buf)
    {
      if (lw6sys_file_exists (buf))
	{
	  ret =
	    lw6cfg_read_key_value_xml_file (buf, read_callback,
					    (void *) options);
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_INFO, "map",
		      _("couldn't find \"%s\", using defaults"), buf);
	  ret = 1;
	}

      LW6SYS_FREE (buf);
    }

  if (!ret)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "map", _("unable to read map options"));
    }

  return ret;
}

void
lw6map_options_clear (LW6OPT_STATIC * options)
{
  if (options)
    {
      memset (options, 0, sizeof (LW6OPT_STATIC));
    }
}
