/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "opt.h"

char *LW6OPT_STATIC_OPTIONS_LIST[] = {
  "total-time",
  "respawn-team",
  "moves-per-round",
  "spread-per-round",
  "rounds-persec",
  "fighter-attack",
  "fighter-defense",
  "fighter-new-health",
  "side-attack-factor",
  "side-defense-factor",
  "nb-move-tries",
  "nb-attack-tries",
  "nb-defense-tries",
  "single-army-surface",
  "total-armies-surface",
  "max-nb-teams",
  "x-polarity",
  "y-polarity",
  "max-zone-size",
  "min-map-width",
  "max-map-width",
  "min-map-height",
  "max-map-height",
  "min-map-surface",
  "max-map-surface",
  "bot-wait-between-moves",
  "bot-nb-move-steps",
  "round-delta",
  "max-round-delta",
  "max-cursor-pot",
  "cursor-pot-init",
  "max-cursor-pot-offset",
  NULL				// very important that this list is NULL-terminated
};

static LW6OPT_STATIC default_static_options = {
  LW6OPT_STATIC_DEFAULT_TOTAL_TIME,
  LW6OPT_STATIC_DEFAULT_RESPAWN_TEAM,
  LW6OPT_STATIC_DEFAULT_MOVES_PER_ROUND,
  LW6OPT_STATIC_DEFAULT_SPREADS_PER_ROUND,
  LW6OPT_STATIC_DEFAULT_ROUNDS_PER_SEC,
  LW6OPT_STATIC_DEFAULT_FIGHTER_ATTACK,
  LW6OPT_STATIC_DEFAULT_FIGHTER_DEFENSE,
  LW6OPT_STATIC_DEFAULT_FIGHTER_NEW_HEALTH,
  LW6OPT_STATIC_DEFAULT_SIDE_ATTACK_FACTOR,
  LW6OPT_STATIC_DEFAULT_SIDE_DEFENSE_FACTOR,
  LW6OPT_STATIC_DEFAULT_NB_MOVE_TRIES,
  LW6OPT_STATIC_DEFAULT_NB_ATTACK_TRIES,
  LW6OPT_STATIC_DEFAULT_NB_DEFENSE_TRIES,
  LW6OPT_STATIC_DEFAULT_SINGLE_ARMY_SURFACE,
  LW6OPT_STATIC_DEFAULT_TOTAL_ARMIES_SURFACE,
  LW6OPT_STATIC_DEFAULT_MAX_NB_TEAMS,
  LW6OPT_STATIC_DEFAULT_X_POLARITY,
  LW6OPT_STATIC_DEFAULT_Y_POLARITY,
  LW6OPT_STATIC_DEFAULT_MAX_ZONE_SIZE,
  LW6OPT_STATIC_DEFAULT_MIN_MAP_WIDTH,
  LW6OPT_STATIC_DEFAULT_MAX_MAP_WIDTH,
  LW6OPT_STATIC_DEFAULT_MIN_MAP_HEIGHT,
  LW6OPT_STATIC_DEFAULT_MAX_MAP_HEIGHT,
  LW6OPT_STATIC_DEFAULT_MIN_MAP_SURFACE,
  LW6OPT_STATIC_DEFAULT_MAX_MAP_SURFACE,
  LW6OPT_STATIC_DEFAULT_BOT_WAIT_BETWEEN_MOVES,
  LW6OPT_STATIC_DEFAULT_BOT_NB_MOVE_STEPS,
  LW6OPT_STATIC_DEFAULT_ROUND_DELTA,
  LW6OPT_STATIC_DEFAULT_MAX_ROUND_DELTA,
  LW6OPT_STATIC_DEFAULT_MAX_CURSOR_POT,
  LW6OPT_STATIC_DEFAULT_CURSOR_POT_INIT,
  LW6OPT_STATIC_DEFAULT_MAX_CURSOR_POT_OFFSET
};

static LW6OPT_STATIC min_static_options = {
  LW6OPT_STATIC_MIN_TOTAL_TIME,
  LW6OPT_STATIC_MIN_RESPAWN_TEAM,
  LW6OPT_STATIC_MIN_MOVES_PER_ROUND,
  LW6OPT_STATIC_MIN_SPREADS_PER_ROUND,
  LW6OPT_STATIC_MIN_ROUNDS_PER_SEC,
  LW6OPT_STATIC_MIN_FIGHTER_ATTACK,
  LW6OPT_STATIC_MIN_FIGHTER_DEFENSE,
  LW6OPT_STATIC_MIN_FIGHTER_NEW_HEALTH,
  LW6OPT_STATIC_MIN_SIDE_ATTACK_FACTOR,
  LW6OPT_STATIC_MIN_SIDE_DEFENSE_FACTOR,
  LW6OPT_STATIC_MIN_NB_MOVE_TRIES,
  LW6OPT_STATIC_MIN_NB_ATTACK_TRIES,
  LW6OPT_STATIC_MIN_NB_DEFENSE_TRIES,
  LW6OPT_STATIC_MIN_SINGLE_ARMY_SURFACE,
  LW6OPT_STATIC_MIN_TOTAL_ARMIES_SURFACE,
  LW6OPT_STATIC_MIN_MAX_NB_TEAMS,
  LW6OPT_STATIC_MIN_X_POLARITY,
  LW6OPT_STATIC_MIN_Y_POLARITY,
  LW6OPT_STATIC_MIN_MAX_ZONE_SIZE,
  LW6OPT_STATIC_MIN_MIN_MAP_WIDTH,
  LW6OPT_STATIC_MIN_MAX_MAP_WIDTH,
  LW6OPT_STATIC_MIN_MIN_MAP_HEIGHT,
  LW6OPT_STATIC_MIN_MAX_MAP_HEIGHT,
  LW6OPT_STATIC_MIN_MIN_MAP_SURFACE,
  LW6OPT_STATIC_MIN_MAX_MAP_SURFACE,
  LW6OPT_STATIC_MIN_BOT_WAIT_BETWEEN_MOVES,
  LW6OPT_STATIC_MIN_BOT_NB_MOVE_STEPS,
  LW6OPT_STATIC_MIN_ROUND_DELTA,
  LW6OPT_STATIC_MIN_MAX_ROUND_DELTA,
  LW6OPT_STATIC_MIN_MAX_CURSOR_POT,
  LW6OPT_STATIC_MIN_CURSOR_POT_INIT,
  LW6OPT_STATIC_MIN_MAX_CURSOR_POT_OFFSET
};

static LW6OPT_STATIC max_static_options = {
  LW6OPT_STATIC_MAX_TOTAL_TIME,
  LW6OPT_STATIC_MAX_RESPAWN_TEAM,
  LW6OPT_STATIC_MAX_MOVES_PER_ROUND,
  LW6OPT_STATIC_MAX_SPREADS_PER_ROUND,
  LW6OPT_STATIC_MAX_ROUNDS_PER_SEC,
  LW6OPT_STATIC_MAX_FIGHTER_ATTACK,
  LW6OPT_STATIC_MAX_FIGHTER_DEFENSE,
  LW6OPT_STATIC_MAX_FIGHTER_NEW_HEALTH,
  LW6OPT_STATIC_MAX_SIDE_ATTACK_FACTOR,
  LW6OPT_STATIC_MAX_SIDE_DEFENSE_FACTOR,
  LW6OPT_STATIC_MAX_NB_MOVE_TRIES,
  LW6OPT_STATIC_MAX_NB_ATTACK_TRIES,
  LW6OPT_STATIC_MAX_NB_DEFENSE_TRIES,
  LW6OPT_STATIC_MAX_SINGLE_ARMY_SURFACE,
  LW6OPT_STATIC_MAX_TOTAL_ARMIES_SURFACE,
  LW6OPT_STATIC_MAX_MAX_NB_TEAMS,
  LW6OPT_STATIC_MAX_X_POLARITY,
  LW6OPT_STATIC_MAX_Y_POLARITY,
  LW6OPT_STATIC_MAX_MAX_ZONE_SIZE,
  LW6OPT_STATIC_MAX_MIN_MAP_WIDTH,
  LW6OPT_STATIC_MAX_MAX_MAP_WIDTH,
  LW6OPT_STATIC_MAX_MIN_MAP_HEIGHT,
  LW6OPT_STATIC_MAX_MAX_MAP_HEIGHT,
  LW6OPT_STATIC_MAX_MIN_MAP_SURFACE,
  LW6OPT_STATIC_MAX_MAX_MAP_SURFACE,
  LW6OPT_STATIC_MAX_BOT_WAIT_BETWEEN_MOVES,
  LW6OPT_STATIC_MAX_BOT_NB_MOVE_STEPS,
  LW6OPT_STATIC_MAX_ROUND_DELTA,
  LW6OPT_STATIC_MAX_MAX_ROUND_DELTA,
  LW6OPT_STATIC_MAX_MAX_CURSOR_POT,
  LW6OPT_STATIC_MAX_CURSOR_POT_INIT,
  LW6OPT_STATIC_MAX_MAX_CURSOR_POT_OFFSET
};

void
lw6opt_static_defaults (LW6OPT_STATIC * static_options)
{
  lw6opt_static_copy (static_options, &default_static_options);
}

void
lw6opt_static_copy (LW6OPT_STATIC * dst, LW6OPT_STATIC * src)
{
  /*
   * Note that in this context, we'd better not use strings
   * in this structure, or code would become a bit more complex.
   */
  memcpy (dst, src, sizeof (LW6OPT_STATIC));
}

void
lw6opt_static_update_checksum (LW6OPT_STATIC *
			       static_options, LW6SYS_UINT32 * checksum)
{
  lw6sys_checksum_update_int32 (checksum, static_options->total_time);
  lw6sys_checksum_update_int32 (checksum, static_options->respawn_team);
  lw6sys_checksum_update_int32 (checksum, static_options->moves_per_round);
  lw6sys_checksum_update_int32 (checksum, static_options->spreads_per_round);
  lw6sys_checksum_update_int32 (checksum, static_options->rounds_per_sec);
  lw6sys_checksum_update_int32 (checksum, static_options->fighter_attack);
  lw6sys_checksum_update_int32 (checksum, static_options->fighter_defense);
  lw6sys_checksum_update_int32 (checksum, static_options->fighter_new_health);
  lw6sys_checksum_update_int32 (checksum, static_options->side_attack_factor);
  lw6sys_checksum_update_int32 (checksum,
				static_options->side_defense_factor);
  lw6sys_checksum_update_int32 (checksum, static_options->nb_move_tries);
  lw6sys_checksum_update_int32 (checksum, static_options->nb_attack_tries);
  lw6sys_checksum_update_int32 (checksum, static_options->nb_defense_tries);
  lw6sys_checksum_update_int32 (checksum,
				static_options->single_army_surface);
  lw6sys_checksum_update_int32 (checksum,
				static_options->total_armies_surface);
  lw6sys_checksum_update_int32 (checksum, static_options->max_nb_teams);
  lw6sys_checksum_update_int32 (checksum, static_options->x_polarity);
  lw6sys_checksum_update_int32 (checksum, static_options->y_polarity);
  lw6sys_checksum_update_int32 (checksum, static_options->max_zone_size);
  lw6sys_checksum_update_int32 (checksum, static_options->min_map_width);
  lw6sys_checksum_update_int32 (checksum, static_options->max_map_width);
  lw6sys_checksum_update_int32 (checksum, static_options->min_map_height);
  lw6sys_checksum_update_int32 (checksum, static_options->max_map_height);
  lw6sys_checksum_update_int32 (checksum, static_options->min_map_surface);
  lw6sys_checksum_update_int32 (checksum, static_options->max_map_surface);
  lw6sys_checksum_update_int32 (checksum,
				static_options->bot_wait_between_moves);
  lw6sys_checksum_update_int32 (checksum, static_options->bot_nb_move_steps);
  lw6sys_checksum_update_int32 (checksum, static_options->round_delta);
  lw6sys_checksum_update_int32 (checksum, static_options->max_round_delta);
  lw6sys_checksum_update_int32 (checksum, static_options->max_cursor_pot);
  lw6sys_checksum_update_int32 (checksum, static_options->cursor_pot_init);
  lw6sys_checksum_update_int32 (checksum,
				static_options->max_cursor_pot_offset);
}

LW6SYS_INT32 *
get_static_options_int_ptr (LW6OPT_STATIC * static_options, char *key)
{
  LW6SYS_INT32 *ret = NULL;

  if (static_options && key)
    {
      if (!strcmp (key, "total-time"))
	{
	  ret = &(static_options->total_time);
	}
      else if (!strcmp (key, "respawn-team"))
	{
	  ret = &(static_options->respawn_team);
	}
      else if (!strcmp (key, "moves-per-round"))
	{
	  ret = &(static_options->moves_per_round);
	}
      else if (!strcmp (key, "spreads-per-round"))
	{
	  ret = &(static_options->spreads_per_round);
	}
      else if (!strcmp (key, "rounds-per-sec"))
	{
	  ret = &(static_options->rounds_per_sec);
	}
      else if (!strcmp (key, "fighter-attack"))
	{
	  ret = &(static_options->fighter_attack);
	}
      else if (!strcmp (key, "fighter-defense"))
	{
	  ret = &(static_options->fighter_defense);
	}
      else if (!strcmp (key, "fighter-new-health"))
	{
	  ret = &(static_options->fighter_new_health);
	}
      else if (!strcmp (key, "side-attack-factor"))
	{
	  ret = &(static_options->side_attack_factor);
	}
      else if (!strcmp (key, "side-defense-factor"))
	{
	  ret = &(static_options->side_defense_factor);
	}
      else if (!strcmp (key, "nb-move-tries"))
	{
	  ret = &(static_options->nb_move_tries);
	}
      else if (!strcmp (key, "nb-attack-tries"))
	{
	  ret = &(static_options->nb_attack_tries);
	}
      else if (!strcmp (key, "nb-defense-tries"))
	{
	  ret = &(static_options->nb_defense_tries);
	}
      else if (!strcmp (key, "single-army-surface"))
	{
	  ret = &(static_options->single_army_surface);
	}
      else if (!strcmp (key, "total-armies-surface"))
	{
	  ret = &(static_options->total_armies_surface);
	}
      else if (!strcmp (key, "max-nb_teams"))
	{
	  ret = &(static_options->max_nb_teams);
	}
      else if (!strcmp (key, "x-polarity"))
	{
	  ret = &(static_options->x_polarity);
	}
      else if (!strcmp (key, "y-polarity"))
	{
	  ret = &(static_options->y_polarity);
	}
      else if (!strcmp (key, "max-zone-size"))
	{
	  ret = &(static_options->max_zone_size);
	}
      else if (!strcmp (key, "min-map-width"))
	{
	  ret = &(static_options->min_map_width);
	}
      else if (!strcmp (key, "max-map-width"))
	{
	  ret = &(static_options->max_map_width);
	}
      else if (!strcmp (key, "min-map-height"))
	{
	  ret = &(static_options->min_map_height);
	}
      else if (!strcmp (key, "max-map-height"))
	{
	  ret = &(static_options->max_map_height);
	}
      else if (!strcmp (key, "min-map-surface"))
	{
	  ret = &(static_options->min_map_surface);
	}
      else if (!strcmp (key, "max-map-surface"))
	{
	  ret = &(static_options->max_map_surface);
	}
      else if (!strcmp (key, "bot-wait-between-moves"))
	{
	  ret = &(static_options->bot_wait_between_moves);
	}
      else if (!strcmp (key, "bot-nb-move-steps"))
	{
	  ret = &(static_options->bot_nb_move_steps);
	}
      else if (!strcmp (key, "round-delta"))
	{
	  ret = &(static_options->round_delta);
	}
      else if (!strcmp (key, "max-round-delta"))
	{
	  ret = &(static_options->max_round_delta);
	}
      else if (!strcmp (key, "max-cursor-pot"))
	{
	  ret = &(static_options->max_cursor_pot);
	}
      else if (!strcmp (key, "cursor-pot-init"))
	{
	  ret = &(static_options->cursor_pot_init);
	}
      else if (!strcmp (key, "max-cursor-pot-offset"))
	{
	  ret = &(static_options->max_cursor_pot_offset);
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "opt",
		      _
		      ("static options key \"%s\" does not exist, can't get a pointer on its value"),
		      key);
	}
    }

  return ret;
}

LW6SYS_INT32
lw6opt_static_get_default (char *key)
{
  LW6SYS_INT32 *ptr;
  LW6SYS_INT32 ret = 0;

  ptr = get_static_options_int_ptr (&default_static_options, key);
  if (ptr)
    {
      ret = (*ptr);
    }

  return ret;
}

LW6SYS_INT32
lw6opt_static_get_min (char *key)
{
  LW6SYS_INT32 *ptr;
  LW6SYS_INT32 ret = 0;

  ptr = get_static_options_int_ptr (&min_static_options, key);
  if (ptr)
    {
      ret = (*ptr);
    }

  return ret;
}

LW6SYS_INT32
lw6opt_static_get_max (char *key)
{
  LW6SYS_INT32 *ptr;
  LW6SYS_INT32 ret = 0;

  ptr = get_static_options_int_ptr (&max_static_options, key);
  if (ptr)
    {
      ret = (*ptr);
    }

  return ret;
}

LW6SYS_INT32
lw6opt_static_get_int (LW6OPT_STATIC * static_options, char *key)
{
  LW6SYS_INT32 ret = 0;
  LW6SYS_INT32 *ptr;
  LW6SYS_INT32 min_value;
  LW6SYS_INT32 max_value;

  ptr = get_static_options_int_ptr (static_options, key);
  if (ptr)
    {
      min_value = lw6opt_static_get_min (key);
      max_value = lw6opt_static_get_max (key);
      if ((*ptr) < min_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "opt",
		      _
		      ("can't get static option \"%s\" (%d), it's too small, returning min value %d instead"),
		      key, (*ptr), min_value);
	  ret = min_value;
	}
      else if ((*ptr) > max_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "opt",
		      _
		      ("can't get static option \"%s\" (%d), it's too big, returning max value %d instead"),
		      key, (*ptr), max_value);
	  ret = max_value;
	}
      else
	{
	  ret = (*ptr);
	}
    }

  return ret;
}

void
lw6opt_static_set_int (LW6OPT_STATIC * static_options, char *key,
		       LW6SYS_INT32 value)
{
  LW6SYS_INT32 *ptr;
  LW6SYS_INT32 min_value;
  LW6SYS_INT32 max_value;

  ptr = get_static_options_int_ptr (static_options, key);
  if (ptr)
    {
      min_value = lw6opt_static_get_min (key);
      max_value = lw6opt_static_get_max (key);
      if ((*ptr) < min_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "opt",
		      _
		      ("can't set static option \"%s\" to value %d, it's too small, using min value %d"),
		      key, (*ptr), min_value);
	  (*ptr) = min_value;
	}
      else if ((*ptr) > max_value)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "opt",
		      _
		      ("can't set static option \"%s\" to value %d, it's too big, using max value %d"),
		      key, (*ptr), max_value);
	  (*ptr) = max_value;
	}
      else
	{
	  (*ptr) = value;
	}
    }
}

LW6SYS_BOOL
lw6opt_static_get_bool (LW6OPT_STATIC * static_options, char *key)
{
  return lw6opt_static_get_int (static_options, key) ? 1 : 0;
}

void
lw6opt_static_set_bool (LW6OPT_STATIC * static_options, char *key,
			LW6SYS_BOOL value)
{
  lw6opt_static_set_int (static_options, key, value ? 1 : 0);
}
