/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6OPT_H
#define LIQUIDWAR6OPT_H

#include "../lw6-common.h"

#include "../sys/sys.h"

#define LW6OPT_MAX_FIGHTER_HEALTH 10000
#define LW6OPT_MAX_NB_TEAMS 10
#define LW6OPT_MAX_CURSORS_PER_TEAM 3
#define LW6OPT_MAX_NB_DIR_TRIES 7

/*
 * All static options default/min/max
 */
#define LW6OPT_STATIC_DEFAULT_TOTAL_TIME 3600	// 1 hour
#define LW6OPT_STATIC_MIN_TOTAL_TIME 30	// 30 seconds
#define LW6OPT_STATIC_MAX_TOTAL_TIME 864000	// 10 days

#define LW6OPT_STATIC_DEFAULT_RESPAWN_TEAM 1
#define LW6OPT_STATIC_MIN_RESPAWN_TEAM 0
#define LW6OPT_STATIC_MAX_RESPAWN_TEAM 1

#define LW6OPT_STATIC_DEFAULT_MOVES_PER_ROUND 2
#define LW6OPT_STATIC_MIN_MOVES_PER_ROUND 1
#define LW6OPT_STATIC_MAX_MOVES_PER_ROUND 10

#define LW6OPT_STATIC_DEFAULT_SPREADS_PER_ROUND 3
#define LW6OPT_STATIC_MIN_SPREADS_PER_ROUND 1
#define LW6OPT_STATIC_MAX_SPREADS_PER_ROUND 12

#define LW6OPT_STATIC_DEFAULT_ROUNDS_PER_SEC 25
#define LW6OPT_STATIC_MIN_ROUNDS_PER_SEC 1
#define LW6OPT_STATIC_MAX_ROUNDS_PER_SEC 100

#define LW6OPT_STATIC_DEFAULT_FIGHTER_ATTACK 500
#define LW6OPT_STATIC_MIN_FIGHTER_ATTACK 1
#define LW6OPT_STATIC_MAX_FIGHTER_ATTACK LW6OPT_MAX_FIGHTER_HEALTH

#define LW6OPT_STATIC_DEFAULT_FIGHTER_DEFENSE 100
#define LW6OPT_STATIC_MIN_FIGHTER_DEFENSE 1
#define LW6OPT_STATIC_MAX_FIGHTER_DEFENSE LW6OPT_MAX_FIGHTER_HEALTH

#define LW6OPT_STATIC_DEFAULT_FIGHTER_NEW_HEALTH 5000
#define LW6OPT_STATIC_MIN_FIGHTER_NEW_HEALTH 1
#define LW6OPT_STATIC_MAX_FIGHTER_NEW_HEALTH LW6OPT_MAX_FIGHTER_HEALTH

#define LW6OPT_STATIC_DEFAULT_SIDE_ATTACK_FACTOR 20	// 20%
#define LW6OPT_STATIC_MIN_SIDE_ATTACK_FACTOR 0
#define LW6OPT_STATIC_MAX_SIDE_ATTACK_FACTOR 100

#define LW6OPT_STATIC_DEFAULT_SIDE_DEFENSE_FACTOR 20	// 20%
#define LW6OPT_STATIC_MIN_SIDE_DEFENSE_FACTOR 0
#define LW6OPT_STATIC_MAX_SIDE_DEFENSE_FACTOR 100

#define LW6OPT_STATIC_DEFAULT_NB_MOVE_TRIES 5
#define LW6OPT_STATIC_MIN_NB_MOVE_TRIES 3
#define LW6OPT_STATIC_MAX_NB_MOVE_TRIES LW6OPT_MAX_NB_DIR_TRIES

#define LW6OPT_STATIC_DEFAULT_NB_ATTACK_TRIES 3
#define LW6OPT_STATIC_MIN_NB_ATTACK_TRIES 1
#define LW6OPT_STATIC_MAX_NB_ATTACK_TRIES LW6OPT_MAX_NB_DIR_TRIES

#define LW6OPT_STATIC_DEFAULT_NB_DEFENSE_TRIES 1
#define LW6OPT_STATIC_MIN_NB_DEFENSE_TRIES 1
#define LW6OPT_STATIC_MAX_NB_DEFENSE_TRIES LW6OPT_MAX_NB_DIR_TRIES

#define LW6OPT_STATIC_DEFAULT_SINGLE_ARMY_SURFACE 75	// 7,5% (per 1000)
#define LW6OPT_STATIC_MIN_SINGLE_ARMY_SURFACE 1
#define LW6OPT_STATIC_MAX_SINGLE_ARMY_SURFACE 300	// << 1000

#define LW6OPT_STATIC_DEFAULT_TOTAL_ARMIES_SURFACE 300	// 30% (per 1000)
#define LW6OPT_STATIC_MIN_TOTAL_ARMIES_SURFACE 5
#define LW6OPT_STATIC_MAX_TOTAL_ARMIES_SURFACE 900	// < 1000

#define LW6OPT_STATIC_DEFAULT_MAX_NB_TEAMS 6
#define LW6OPT_STATIC_MIN_MAX_NB_TEAMS 2
#define LW6OPT_STATIC_MAX_MAX_NB_TEAMS LW6OPT_MAX_NB_TEAMS

#define LW6OPT_STATIC_DEFAULT_X_POLARITY 0
#define LW6OPT_STATIC_MIN_X_POLARITY -1
#define LW6OPT_STATIC_MAX_X_POLARITY 1

#define LW6OPT_STATIC_DEFAULT_Y_POLARITY 0
#define LW6OPT_STATIC_MIN_Y_POLARITY -1
#define LW6OPT_STATIC_MAX_Y_POLARITY 1

#define LW6OPT_STATIC_DEFAULT_MAX_ZONE_SIZE 8
#define LW6OPT_STATIC_MIN_MAX_ZONE_SIZE 1
#define LW6OPT_STATIC_MAX_MAX_ZONE_SIZE 64

#define LW6OPT_STATIC_DEFAULT_MIN_MAP_WIDTH 80
#define LW6OPT_STATIC_MIN_MIN_MAP_WIDTH 20
#define LW6OPT_STATIC_MAX_MIN_MAP_WIDTH 5000

#define LW6OPT_STATIC_DEFAULT_MAX_MAP_WIDTH 400
#define LW6OPT_STATIC_MIN_MAX_MAP_WIDTH 20
#define LW6OPT_STATIC_MAX_MAX_MAP_WIDTH 5000

#define LW6OPT_STATIC_DEFAULT_MIN_MAP_HEIGHT 60
#define LW6OPT_STATIC_MIN_MIN_MAP_HEIGHT 20
#define LW6OPT_STATIC_MAX_MIN_MAP_HEIGHT 5000

#define LW6OPT_STATIC_DEFAULT_MAX_MAP_HEIGHT 300
#define LW6OPT_STATIC_MIN_MAX_MAP_HEIGHT 20
#define LW6OPT_STATIC_MAX_MAX_MAP_HEIGHT 5000

#define LW6OPT_STATIC_DEFAULT_MIN_MAP_SURFACE (LW6OPT_STATIC_DEFAULT_MIN_MAP_WIDTH*LW6OPT_STATIC_DEFAULT_MIN_MAP_HEIGHT)
#define LW6OPT_STATIC_MIN_MIN_MAP_SURFACE (LW6OPT_STATIC_MIN_MIN_MAP_WIDTH*LW6OPT_STATIC_MIN_MIN_MAP_HEIGHT)
#define LW6OPT_STATIC_MAX_MIN_MAP_SURFACE (LW6OPT_STATIC_MAX_MIN_MAP_WIDTH*LW6OPT_STATIC_MAX_MIN_MAP_HEIGHT)

#define LW6OPT_STATIC_DEFAULT_MAX_MAP_SURFACE (LW6OPT_STATIC_DEFAULT_MAX_MAP_WIDTH*LW6OPT_STATIC_DEFAULT_MAX_MAP_HEIGHT)
#define LW6OPT_STATIC_MIN_MAX_MAP_SURFACE (LW6OPT_STATIC_MIN_MAX_MAP_WIDTH*LW6OPT_STATIC_MIN_MAX_MAP_HEIGHT)
#define LW6OPT_STATIC_MAX_MAX_MAP_SURFACE (LW6OPT_STATIC_MAX_MAX_MAP_WIDTH*LW6OPT_STATIC_MAX_MAX_MAP_HEIGHT)

#define LW6OPT_STATIC_DEFAULT_BOT_WAIT_BETWEEN_MOVES 100
#define LW6OPT_STATIC_MIN_BOT_WAIT_BETWEEN_MOVES 0
#define LW6OPT_STATIC_MAX_BOT_WAIT_BETWEEN_MOVES 10000

#define LW6OPT_STATIC_DEFAULT_BOT_NB_MOVE_STEPS 25
#define LW6OPT_STATIC_MIN_BOT_NB_MOVE_STEPS 1
#define LW6OPT_STATIC_MAX_BOT_NB_MOVE_STEPS 10000

#define LW6OPT_STATIC_DEFAULT_ROUND_DELTA 1
#define LW6OPT_STATIC_MIN_ROUND_DELTA 0
#define LW6OPT_STATIC_MAX_ROUND_DELTA 100

#define LW6OPT_STATIC_DEFAULT_MAX_ROUND_DELTA 1000
#define LW6OPT_STATIC_MIN_MAX_ROUND_DELTA 1
#define LW6OPT_STATIC_MAX_MAX_ROUND_DELTA 10000

#define LW6OPT_STATIC_DEFAULT_MAX_CURSOR_POT 1000000
#define LW6OPT_STATIC_MIN_MAX_CURSOR_POT 50000
#define LW6OPT_STATIC_MAX_MAX_CURSOR_POT 5000000

#define LW6OPT_STATIC_DEFAULT_CURSOR_POT_INIT 100000
#define LW6OPT_STATIC_MIN_CURSOR_POT_INIT 5000
#define LW6OPT_STATIC_MAX_CURSOR_POT_INIT 500000

#define LW6OPT_STATIC_DEFAULT_MAX_CURSOR_POT_OFFSET 100
#define LW6OPT_STATIC_MIN_MAX_CURSOR_POT_OFFSET 1
#define LW6OPT_STATIC_MAX_MAX_CURSOR_POT_OFFSET 10000

/*
 * Note: it's important that floats are never ever used in map options.
 * In fact, we need maps to be 100,00 (lots of zeroes) predictable,
 * given some identical user actions. Using floats could lead us
 * to very slight differences (floats are never accurate, especially
 * when you run calculus on different hardwares) which could, with
 * time, become very important. Sort of a "butterfly effect".
 * So well, we use int. Int32 to be exact.
 */

typedef struct LW6OPT_DYNAMIC_STRUCT
{
  /*
   * None for now, the hard thing is to find a way to make people
   * agree on "OK we change the rules now!".
   */
}
LW6OPT_DYNAMIC;

typedef struct LW6OPT_STATIC_STRUCT
{
  LW6SYS_INT32 total_time;
  LW6SYS_INT32 respawn_team;
  LW6SYS_INT32 moves_per_round;
  LW6SYS_INT32 spreads_per_round;
  LW6SYS_INT32 rounds_per_sec;
  LW6SYS_INT32 fighter_attack;
  LW6SYS_INT32 fighter_defense;
  LW6SYS_INT32 fighter_new_health;
  LW6SYS_INT32 side_attack_factor;
  LW6SYS_INT32 side_defense_factor;
  LW6SYS_INT32 nb_move_tries;
  LW6SYS_INT32 nb_attack_tries;
  LW6SYS_INT32 nb_defense_tries;
  LW6SYS_INT32 single_army_surface;
  LW6SYS_INT32 total_armies_surface;
  LW6SYS_INT32 max_nb_teams;
  LW6SYS_INT32 x_polarity;
  LW6SYS_INT32 y_polarity;
  LW6SYS_INT32 max_zone_size;
  LW6SYS_INT32 min_map_width;
  LW6SYS_INT32 max_map_width;
  LW6SYS_INT32 min_map_height;
  LW6SYS_INT32 max_map_height;
  LW6SYS_INT32 min_map_surface;
  LW6SYS_INT32 max_map_surface;
  LW6SYS_INT32 bot_wait_between_moves;
  LW6SYS_INT32 bot_nb_move_steps;
  LW6SYS_INT32 round_delta;
  LW6SYS_INT32 max_round_delta;
  LW6SYS_INT32 max_cursor_pot;
  LW6SYS_INT32 cursor_pot_init;
  LW6SYS_INT32 max_cursor_pot_offset;
}
LW6OPT_STATIC;

extern char *LW6OPT_STATIC_OPTIONS_LIST[];

/*
 * In dynamic.c
 */
extern LW6SYS_BOOL lw6opt_dynamic_init (LW6OPT_DYNAMIC *
					dynamic_options,
					LW6OPT_STATIC static_options);
extern void lw6opt_dynamic_copy (LW6OPT_DYNAMIC * dst, LW6OPT_DYNAMIC * src);
extern void lw6opt_dynamic_update_checksum (LW6OPT_DYNAMIC *
					    dynamic_options,
					    LW6SYS_UINT32 * checksum);

/*
 * In static.c
 */
extern void lw6opt_static_defaults (LW6OPT_STATIC * static_options);
extern void lw6opt_static_copy (LW6OPT_STATIC * dst, LW6OPT_STATIC * src);
extern void lw6opt_static_update_checksum (LW6OPT_STATIC *
					   static_options,
					   LW6SYS_UINT32 * checksum);
extern LW6SYS_INT32 lw6opt_static_get_default (char *key);
extern LW6SYS_INT32 lw6opt_static_get_min (char *key);
extern LW6SYS_INT32 lw6opt_static_get_max (char *key);
extern LW6SYS_INT32 lw6opt_static_get_int (LW6OPT_STATIC * static_options,
					   char *key);
extern void lw6opt_static_set_int (LW6OPT_STATIC * static_options, char *key,
				   LW6SYS_INT32 value);
extern LW6SYS_BOOL lw6opt_static_get_bool (LW6OPT_STATIC * static_options,
					   char *key);
extern void lw6opt_static_set_bool (LW6OPT_STATIC * static_options, char *key,
				    LW6SYS_BOOL value);

#endif
