/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>

#include <string.h>

#include "config.h"
#include "../snd.h"
#include "mod-ogg.h"
#include "mod-ogg-internal.h"


static int
play_sound (void *snd_context, int sound_id)
{
  int ret = 0;

  _MOD_OGG_CONTEXT *mod_ogg_context = (_MOD_OGG_CONTEXT *) snd_context;

  if (mod_ogg_context)
    {
      ret = _mod_ogg_play_sound (mod_ogg_context, sound_id);
    }

  return ret;
}

static int
play_music (void *snd_context, char *music_name)
{
  int ret = 0;

  _MOD_OGG_CONTEXT *mod_ogg_context = (_MOD_OGG_CONTEXT *) snd_context;

  if (mod_ogg_context)
    {
      ret = _mod_ogg_play_music (mod_ogg_context, music_name);
    }

  return ret;
}

static void *
init (float sound_volume, float music_volume)
{
  _MOD_OGG_CONTEXT *mod_ogg_context =
    _mod_ogg_init (sound_volume, music_volume);

  return (void *) mod_ogg_context;
}

static void
set_sound_volume (void *snd_context, float volume)
{
  _MOD_OGG_CONTEXT *mod_ogg_context = (_MOD_OGG_CONTEXT *) snd_context;

  if (mod_ogg_context)
    {
      _mod_ogg_set_sound_volume (mod_ogg_context, volume);
    }
}

static void
set_music_volume (void *snd_context, float volume)
{
  _MOD_OGG_CONTEXT *mod_ogg_context = (_MOD_OGG_CONTEXT *) snd_context;

  if (mod_ogg_context)
    {
      _mod_ogg_set_music_volume (mod_ogg_context, volume);
    }
}

static void
quit (void *snd_context)
{
  _MOD_OGG_CONTEXT *mod_ogg_context = (_MOD_OGG_CONTEXT *) snd_context;

  if (mod_ogg_context)
    {
      _mod_ogg_quit (mod_ogg_context);
    }
}

LW6SND_BACKEND *
mod_ogg_create_backend ()
{
  LW6SND_BACKEND *backend;

  backend = LW6SYS_MALLOC (sizeof (LW6SND_BACKEND));
  if (backend)
    {
      memset (backend, 0, sizeof (LW6SND_BACKEND));

      backend->play_sound = play_sound;
      backend->play_music = play_music;
      backend->init = init;
      backend->set_sound_volume = set_sound_volume;
      backend->set_music_volume = set_music_volume;
      backend->quit = quit;
    }

  return backend;
}
