/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <locale.h>

#include "config.h"
#include "snd.h"

#define TEST_SOUND_VOLUME 0.6f
#define TEST_MUSIC_VOLUME 0.4f
#define TEST_SOUND_SLEEP 1.0f

#define FUNCTION_BEGIN { lw6sys_log(LW6SYS_LOG_DEBUG,"snd-test",_("running tests in \"%s\""),__FUNCTION__); }
#define FUNCTION_END   if (ret) { lw6sys_log(LW6SYS_LOG_DEBUG,"snd-test",_("tests in \"%s\" OK"),__FUNCTION__); } else { lw6sys_log(LW6SYS_LOG_WARNING,"snd-test",_("tests in \"%s\" failed"),__FUNCTION__); }

static int
test_init (LW6SND_BACKEND * backend)
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    ret = ret && lw6snd_init (backend, TEST_SOUND_VOLUME, TEST_MUSIC_VOLUME);
  }

  FUNCTION_END;
  return ret;
}

static int
test_play_sound (LW6SND_BACKEND * backend)
{
  int ret = 1;
  FUNCTION_BEGIN;

  {
    int i;

    for (i = 0; i < LW6SND_NB_SOUNDS; ++i)
      {
	if (lw6snd_play_sound (backend, i))
	  {
	    lw6sys_sleep (TEST_SOUND_SLEEP);
	  }
	else
	  {
	    ret = 0;
	  }
      }
  }

  FUNCTION_END;
  return ret;
}

static int
test_quit (LW6SND_BACKEND * backend)
{
  int ret = 1;
  FUNCTION_BEGIN;

  lw6snd_quit (backend);

  FUNCTION_END;
  return ret;
}

int
main (int argc, char *argv[])
{
  int ret = 1;
  LW6SND_BACKEND *backend;

  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE_TARNAME, LW6_LOCALE_DIR);
  textdomain (PACKAGE_TARNAME);

  backend = lw6snd_create_backend ("ogg");
  ret = test_init (backend) && test_play_sound (backend)
    && test_quit (backend);
  lw6snd_destroy_backend (backend);

  backend = lw6snd_create_backend ("csound");
  ret = test_init (backend) && test_play_sound (backend)
    && test_quit (backend);
  lw6snd_destroy_backend (backend);

  ret = ret && lw6sys_check_malloc_free_count ();

  return (!ret);
}
