/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6SND_H
#define LIQUIDWAR6SND_H

#include "../lw6-common.h"

#include "../sys/sys.h"
#include "../dyn/dyn.h"

#define LW6SND_NB_SOUNDS 4
typedef enum LW6SND_SOUND_ENUM
{
  LW6SND_SOUND_SPLASH = 0,
  LW6SND_SOUND_BEEP_ENTER = 1,
  LW6SND_SOUND_BEEP_SELECT = 2,
  LW6SND_SOUND_START = 3
}
LW6SND_SOUND;


typedef struct LW6SND_BACKEND_STRUCT
{
  LW6DYN_DL_HANDLE *dl_handle;
  void *snd_context;

  int (*play_sound) (void *snd_context, int sound_id);
  int (*play_music) (void *snd_context, char *music_name);
  void *(*init) (float sound_volume, float music_volume);
  void (*set_sound_volume) (void *snd_context, float volume);
  void (*set_music_volume) (void *snd_context, float volume);
  void (*quit) (void *snd_context);
}
LW6SND_BACKEND;

/*
 * In api.c
 */
extern int lw6snd_play_sound (LW6SND_BACKEND * backend, int sound_id);
extern int lw6snd_play_music (LW6SND_BACKEND * backend, char *music_name);
extern int lw6snd_init (LW6SND_BACKEND * backend, float sound_volume,
			float music_volume);
extern void lw6snd_set_sound_volume (LW6SND_BACKEND * backend, float volume);
extern void lw6snd_set_music_volume (LW6SND_BACKEND * backend, float volume);
extern void lw6snd_quit (LW6SND_BACKEND * backend);

/*
 * In register.c
 */
extern LW6SYS_ASSOC *lw6snd_get_backends ();
extern LW6SND_BACKEND *lw6snd_create_backend (char *name);
extern void lw6snd_destroy_backend (LW6SND_BACKEND * backend);

#endif
