/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "config.h"
#include "sys.h"

#define FLOAT2CHAR_FACTOR 255.0f

LW6SYS_COLOR_F LW6SYS_COLOR_F_WHITE = { 1.0f, 1.0f, 1.0f, 1.0f };
LW6SYS_COLOR_F LW6SYS_COLOR_F_BLACK = { 0.0f, 0.0f, 0.0f, 1.0f };
LW6SYS_COLOR_8 LW6SYS_COLOR_8_WHITE = { 255, 255, 255, 255 };
LW6SYS_COLOR_8 LW6SYS_COLOR_8_BLACK = { 0, 0, 0, 255 };

static inline LW6SYS_UINT8
float2char (float comp)
{
  return comp * FLOAT2CHAR_FACTOR;
}

static inline float
char2float (LW6SYS_UINT8 comp)
{
  return comp / FLOAT2CHAR_FACTOR;
}

LW6SYS_UINT8
lw6sys_color_float2char (float comp)
{
  return float2char (comp);
}

float
lw6sys_color_char2float (LW6SYS_UINT8 comp)
{
  return char2float (comp);
}

LW6SYS_COLOR_8
lw6sys_color_f_to_8 (LW6SYS_COLOR_F * color_f)
{
  LW6SYS_COLOR_8 ret;

  ret.r = float2char (color_f->r);
  ret.g = float2char (color_f->g);
  ret.b = float2char (color_f->b);
  ret.a = float2char (color_f->a);

  return ret;
}

void
lw6sys_color_8_to_f (LW6SYS_COLOR_F * color_f, LW6SYS_COLOR_8 color_8)
{
  color_f->r = char2float (color_8.r);
  color_f->g = char2float (color_8.g);
  color_f->b = char2float (color_8.b);
  color_f->a = char2float (color_8.a);
}

LW6SYS_UINT32
lw6sys_color_f_to_i (LW6SYS_COLOR_F * color_f)
{
  LW6SYS_UINT32 ret;

  LW6SYS_UINT8 *p = (LW6SYS_UINT8 *) & ret;

  p[0] = float2char (color_f->r);
  p[1] = float2char (color_f->g);
  p[2] = float2char (color_f->b);
  p[3] = float2char (color_f->a);

  return ret;
}

LW6SYS_UINT32
lw6sys_color_8_to_i (LW6SYS_COLOR_8 color_8)
{
  LW6SYS_UINT32 ret;

  LW6SYS_UINT8 *p = (LW6SYS_UINT8 *) & ret;

  p[0] = color_8.r;
  p[1] = color_8.g;
  p[2] = color_8.b;
  p[3] = color_8.a;

  return ret;
}

void
lw6sys_color_i_to_f (LW6SYS_COLOR_F * color, LW6SYS_UINT32 color_i)
{
  LW6SYS_UINT8 *p = (LW6SYS_UINT8 *) & color_i;

  color->r = char2float (p[0]);
  color->g = char2float (p[1]);
  color->b = char2float (p[2]);
  color->a = char2float (p[3]);
}

LW6SYS_COLOR_8
lw6sys_color_i_to_8 (LW6SYS_UINT32 color_i)
{
  LW6SYS_COLOR_8 ret;
  LW6SYS_UINT8 *p = (LW6SYS_UINT8 *) & color_i;

  ret.r = p[0];
  ret.g = p[1];
  ret.b = p[2];
  ret.a = p[3];

  return ret;
}

LW6SYS_COLOR_8
lw6sys_color_a_to_8 (char *ascii)
{
  LW6SYS_COLOR_8 ret;

  ret.r = 0x00;
  ret.g = 0x00;
  ret.b = 0x00;
  ret.a = 0xFF;

  if (ascii[0] == '#')
    {
      char buf[3];
      LW6SYS_UINT8 c;

      memset (buf, 0, 3);
      switch (strlen (ascii + 1))
	{
	case 4:
	  buf[0] = ascii[4];
	  c = strtol (buf, NULL, 16);
	  ret.a = c + (c << 4);
	  // Important *NOT* to put a break here.
	case 3:
	  buf[0] = ascii[1];
	  c = strtol (buf, NULL, 16);
	  ret.r = c + (c << 4);
	  buf[0] = ascii[2];
	  c = strtol (buf, NULL, 16);
	  ret.g = c + (c << 4);
	  buf[0] = ascii[3];
	  c = strtol (buf, NULL, 16);
	  ret.b = c + (c << 4);
	  break;
	case 8:
	  buf[0] = ascii[7];
	  buf[1] = ascii[8];
	  ret.a = strtol (buf, NULL, 16);
	  // Important *NOT* to put a break here.
	case 6:
	  buf[0] = ascii[1];
	  buf[1] = ascii[2];
	  ret.r = strtol (buf, NULL, 16);
	  buf[0] = ascii[3];
	  buf[1] = ascii[4];
	  ret.g = strtol (buf, NULL, 16);
	  buf[0] = ascii[5];
	  buf[1] = ascii[6];
	  ret.b = strtol (buf, NULL, 16);
	  break;
	default:
	  lw6sys_log (LW6SYS_LOG_WARNING, "cfg",
		      _
		      ("invalid color value \"%s\", color format must be \"#RGB\", \"#RGBA\", \"#RRGGBB\" or \"#RRGGBBAA\""),
		      ascii);
	}
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "cfg",
		  _
		  ("invalid color value \"%s\", color value must start with \"#\""),
		  ascii);
    }

  return ret;
}

void
lw6sys_color_a_to_f (LW6SYS_COLOR_F * color_f, char *ascii)
{
  LW6SYS_COLOR_8 color_8;

  color_8 = lw6sys_color_a_to_8 (ascii);
  lw6sys_color_8_to_f (color_f, color_8);
}
