/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <stdarg.h>

#include "config.h"
#include "sys.h"

/*
 * Duplicate a string, creating a new pointer on it, which 
 * must be freed afterwards. The main difference with strdup
 * is that here we use the LW6SYS_MALLOC macro to track down
 * possible memory leaks.
 */
char *
lw6sys_str_copy (char *src)
{
  char *copy = NULL;
  int length;

  length = strlen (src);
  copy = LW6SYS_MALLOC (length + 1);
  if (copy)
    {
      strncpy (copy, src, length + 1);
      copy[length] = '\0';
    }

  return copy;
}

/*
 * Concatenate 2 strings, and put the result in a newly
 * allocated string. Unlike strcat which uses the same
 * pointer.
 */
char *
lw6sys_str_concat (char *str1, char *str2)
{
  char *concat = NULL;
  int length;

  length = strlen (str1) + strlen (str2);
  concat = LW6SYS_MALLOC (length + 1);
  if (concat)
    {
      snprintf (concat, length + 1, "%s%s", str1, str2);
      concat[length] = '\0';
    }

  return concat;
}

static char *
new_vsnprintf (int n, char *fmt, va_list ap)
{
  char *ret = NULL;
  int written;

  if (n > 0)
    {
      ret = (char *) LW6SYS_MALLOC (n);

      if (ret)
	{
	  written = vsnprintf (ret, n, fmt, ap);
	  if (written < 0 || written >= n)
	    {
	      /*
	       * Problem, either error or string too long.
	       */
	      LW6SYS_FREE (ret);
	      ret = NULL;
	    }
	  else
	    {
	      ret[n - 1] = '\0';
	    }
	}
    }

  return ret;
}



/*
 * An sprintf like function, except it allocates a new
 * string automatically, with "enough space" 8-)
 */
char *
lw6sys_new_sprintf (char *fmt, ...)
{
  char *ret = NULL;
  va_list ap;

  if (fmt != NULL)
    {
      va_start (ap, fmt);

      int n = strlen (fmt);

      while (ret == NULL)
	{
	  va_list ap2;

	  va_copy (ap2, ap);
	  ret = new_vsnprintf (n, fmt, ap2);
	  va_end (ap2);

	  /*
	   * Loop until we have our string!
	   * In case there is actually no more memory
	   * this will loop forever. In case there's no more
	   * memory for a simple, game and possibly machine
	   * will collapse anyway...
	   */
	  n = ((n * 11) / 10) + 1;	// + 10% + 1 char
	}

      va_end (ap);
    }

  return ret;
}
