/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <time.h>

#include "config.h"
#include "sys.h"

/*
 * Simple wrapper on time function.
 */
long long
lw6sys_timestamp ()
{
  return time (NULL);
}

/*
 * Sleep function using select for accuracy.
 */
void
lw6sys_sleep (float seconds)
{
  struct timeval tv;

  tv.tv_sec = (int) seconds;
  tv.tv_usec = (int) ((seconds - tv.tv_sec) * 1000000.0f);

  select (0, NULL, NULL, NULL, &tv);
}
