/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>

#include "config.h"
#include "cfg.h"
#include "cfg-internal.h"

_LW6CFG_CONTEXT *
_lw6cfg_init ()
{
  _LW6CFG_CONTEXT *context = NULL;

  context = (_LW6CFG_CONTEXT *) LW6SYS_MALLOC (sizeof (_LW6CFG_CONTEXT));
  if (context)
    {
      _lw6cfg_set_default_system_config_file (context);
      _lw6cfg_set_default_user_config_file (context);
      context->options = lw6sys_assoc_new (lw6sys_free_callback);
      if (!context->options)
	{
	  LW6SYS_FREE (context);
	  context = NULL;
	}
    }

  if (!context)
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "cfg",
		  _("unable to initialize config"));
    }

  return context;
}

void *
lw6cfg_init ()
{
  return (void *) _lw6cfg_init ();
}

void
_lw6cfg_quit (_LW6CFG_CONTEXT * context)
{
  if (context)
    {
      LW6SYS_FREE (context->default_system_config_file);
      LW6SYS_FREE (context->default_user_config_file);
      lw6sys_assoc_free (context->options);
      LW6SYS_FREE (context);
    }
}

void
lw6cfg_quit (void *context)
{
  _lw6cfg_quit ((_LW6CFG_CONTEXT *) context);
}
