/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>

#include <GL/glu.h>

#include "config.h"
#include "../../mod-gl.h"
#include "gl-fire-internal.h"

static void
set_background_texture_options (MOD_GL_UTILS_CONTEXT * utils_context,
				_MOD_GL_BACKGROUND_FIRE_CONTEXT *
				fire_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}

static void
background_display (MOD_GL_UTILS_CONTEXT * utils_context,
		    _MOD_GL_BACKGROUND_FIRE_CONTEXT * fire_context)
{
  mod_gl_utils_set_render_mode_2d (utils_context);

  glBindTexture (GL_TEXTURE_2D, fire_context->texture_data.background);
  set_background_texture_options (utils_context, fire_context);

  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();
  glBegin (GL_QUADS);
  glTexCoord2d (0.0f, 0.0f);
  glVertex3f (0.0f, 0.0f, 0.0f);	// top left
  glTexCoord2d (1.0f, 0.0f);
  glVertex3f (utils_context->screen.width, 0.0f, 0.0f);	// top right
  glTexCoord2d (1.0f, 1.0f);
  glVertex3f (utils_context->screen.width, utils_context->screen.height, 0.0f);	// bottom right
  glTexCoord2d (0.0f, 1.0f);
  glVertex3f (0.0f, utils_context->screen.height, 0.0f);	// bottom left
  glEnd ();

  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();
}


void
_mod_gl_background_fire_display (MOD_GL_UTILS_CONTEXT * utils_context,
				 _MOD_GL_BACKGROUND_FIRE_CONTEXT *
				 fire_context)
{
  background_display (utils_context, fire_context);
}

void
mod_gl_background_fire_display (MOD_GL_UTILS_CONTEXT * utils_context,
				void *fire_context)
{
  _mod_gl_background_fire_display (utils_context, fire_context);
}
