
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>

#include <GL/glu.h>
#include <SDL/SDL_image.h>

#include "config.h"
#include "../../gfx.h"
#include "../../../cfg/cfg.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

#define CONST_FILE "gfx/gl/utils/const.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  MOD_GL_UTILS_CONST_DATA *const_data;

  const_data = (MOD_GL_UTILS_CONST_DATA *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, "menu-max-displayed-items",
			   &const_data->menu_max_displayed_items);
      lw6cfg_read_xml_int (key, value, "menu-font-size",
			   &const_data->menu_font_size);
      lw6cfg_read_xml_int (key, value, "system-font-size",
			   &const_data->system_font_size);
      lw6cfg_read_xml_int (key, value, "system-font-dw",
			   &const_data->system_font_dw);
      lw6cfg_read_xml_int (key, value, "system-font-dh",
			   &const_data->system_font_dh);
    }

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "quit-sleep",
			     &const_data->quit_sleep);
      lw6cfg_read_xml_float (key, value, "persp-fovy",
			     &const_data->persp_fovy);
      lw6cfg_read_xml_float (key, value, "persp-znear",
			     &const_data->persp_znear);
      lw6cfg_read_xml_float (key, value, "persp-zfar",
			     &const_data->persp_zfar);
      lw6cfg_read_xml_float (key, value, "system-font-hcoef",
			     &const_data->system_font_hcoef);
      lw6cfg_read_xml_float (key, value, "gradient-opacity",
			     &const_data->gradient_opacity);
      lw6cfg_read_xml_float (key, value, "zones-opacity",
			     &const_data->zones_opacity);
    }

  if (!strcmp (element, "color"))
    {
      lw6cfg_read_xml_color (key, value, "system-font-fg",
			     &const_data->system_font_fg);
      lw6cfg_read_xml_color (key, value, "system-font-shade",
			     &const_data->system_font_shade);
    }
}

/*
 * Loads constants.
 */
int
_mod_gl_utils_load_consts (MOD_GL_UTILS_CONTEXT * context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_find_data_file (CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, "gfx-mod-gl", _("reading \"%s\""),
		  const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(context->const_data));

      LW6SYS_FREE (const_file);
    }

  return ret;
}

/*
 * Unload constants, free memory
 */
void
_mod_gl_utils_unload_consts (MOD_GL_UTILS_CONTEXT * context)
{
  memset (&context->const_data, 0, sizeof (MOD_GL_UTILS_CONST_DATA));
}
