/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_VIEW_FLAT_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_VIEW_FLAT_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "gl-flat.h"

typedef struct _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP_STRUCT
{
  int map_id;
  LW6MAP_MAP *map;
  MOD_GL_UTILS_TEXTURE_ARRAY map_texture_array;
}
_MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP;

typedef struct _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES_STRUCT
{
  int game_state_id;
  LW6KER_GAME_STATE *game_state;
  MOD_GL_UTILS_SURFACE_ARRAY armies_surface_array;
  MOD_GL_UTILS_TEXTURE_ARRAY armies_texture_arrays[LW6MAP_MAX_DEPTH];
}
_MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES;

typedef struct _MOD_GL_VIEW_FLAT_GAME_CONTEXT_STRUCT
{
  _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP map;
  _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES armies;
}
_MOD_GL_VIEW_FLAT_GAME_CONTEXT;

typedef struct _MOD_GL_VIEW_FLAT_CONST_DATA_STRUCT
{
  float cursor_size;
  int tile_size_map;
  int tile_size_armies;
}
_MOD_GL_VIEW_FLAT_CONST_DATA;

typedef struct _MOD_GL_VIEW_FLAT_CONTEXT_STRUCT
{
  _MOD_GL_VIEW_FLAT_GAME_CONTEXT game_context;
  _MOD_GL_VIEW_FLAT_CONST_DATA const_data;
}
_MOD_GL_VIEW_FLAT_CONTEXT;

/*
 * In data.c
 */
extern int _mod_gl_view_flat_load_data (MOD_GL_UTILS_CONTEXT *
					utils_context,
					_MOD_GL_VIEW_FLAT_CONTEXT *
					flat_context);
extern void _mod_gl_view_flat_unload_data (MOD_GL_UTILS_CONTEXT *
					   utils_context,
					   _MOD_GL_VIEW_FLAT_CONTEXT *
					   flat_context);

/*
 * In display.c
 */
extern void _mod_gl_view_flat_display_preview (MOD_GL_UTILS_CONTEXT *
					       utils_context,
					       _MOD_GL_VIEW_FLAT_CONTEXT *
					       flat_context,
					       LW6MAP_MAP * map);
extern void _mod_gl_view_flat_display_zones (MOD_GL_UTILS_CONTEXT *
					     utils_context,
					     _MOD_GL_VIEW_FLAT_CONTEXT *
					     flat_context, LW6MAP_MAP * map,
					     LW6KER_MAP_STRUCT * map_struct);
extern void _mod_gl_view_flat_display_gradient (MOD_GL_UTILS_CONTEXT *
						utils_context,
						_MOD_GL_VIEW_FLAT_CONTEXT *
						flat_context,
						LW6MAP_MAP * map,
						LW6KER_MAP_STATE * map_state,
						int team_id);
extern void _mod_gl_view_flat_display_game (MOD_GL_UTILS_CONTEXT *
					    utils_context,
					    _MOD_GL_VIEW_FLAT_CONTEXT *
					    flat_context, LW6MAP_MAP * map,
					    LW6KER_GAME_STATE * game_state,
					    LW6GFX_GAME_LOOK * game_look);
/*
 * In gamecontext.c
 */
extern int _mod_gl_view_flat_game_context_init (MOD_GL_UTILS_CONTEXT *
						utils_context,
						_MOD_GL_VIEW_FLAT_CONTEXT
						* flat_context,
						_MOD_GL_VIEW_FLAT_GAME_CONTEXT
						* game_context,
						LW6MAP_MAP * map,
						LW6KER_GAME_STATE *
						game_state,
						LW6GFX_GAME_LOOK * game_look);
extern int _mod_gl_view_flat_game_context_init_map (MOD_GL_UTILS_CONTEXT *
						    utils_context,
						    _MOD_GL_VIEW_FLAT_CONTEXT
						    * flat_context,
						    _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP
						    * game_context_map,
						    LW6MAP_MAP * map);
extern int _mod_gl_view_flat_game_context_init_armies (MOD_GL_UTILS_CONTEXT *
						       utils_context,
						       _MOD_GL_VIEW_FLAT_CONTEXT
						       * flat_context,
						       _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES
						       * game_context_armies,
						       LW6KER_GAME_STATE *
						       game_state,
						       LW6GFX_GAME_LOOK *
						       game_look);
extern void _mod_gl_view_flat_game_context_clear (MOD_GL_UTILS_CONTEXT *
						  utils_context,
						  _MOD_GL_VIEW_FLAT_CONTEXT *
						  flat_context,
						  _MOD_GL_VIEW_FLAT_GAME_CONTEXT
						  * game_context);
extern void _mod_gl_view_flat_game_context_clear_map (MOD_GL_UTILS_CONTEXT *
						      utils_context,
						      _MOD_GL_VIEW_FLAT_CONTEXT
						      * flat_context,
						      _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP
						      * game_context_map);
extern void _mod_gl_view_flat_game_context_clear_armies (MOD_GL_UTILS_CONTEXT
							 * utils_context,
							 _MOD_GL_VIEW_FLAT_CONTEXT
							 * flat_context,
							 _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES
							 *
							 game_context_armies);
extern int _mod_gl_view_flat_game_context_update (MOD_GL_UTILS_CONTEXT *
						  utils_context,
						  _MOD_GL_VIEW_FLAT_CONTEXT *
						  flat_context,
						  _MOD_GL_VIEW_FLAT_GAME_CONTEXT
						  * game_context,
						  LW6MAP_MAP * map,
						  LW6KER_GAME_STATE *
						  game_state,
						  LW6GFX_GAME_LOOK *
						  game_look);
extern int _mod_gl_view_flat_game_context_update_map (MOD_GL_UTILS_CONTEXT *
						      utils_context,
						      _MOD_GL_VIEW_FLAT_CONTEXT
						      * flat_context,
						      _MOD_GL_VIEW_FLAT_GAME_CONTEXT_MAP
						      * game_context_map,
						      LW6MAP_MAP * map);
extern int _mod_gl_view_flat_game_context_update_armies (MOD_GL_UTILS_CONTEXT
							 * utils_context,
							 _MOD_GL_VIEW_FLAT_CONTEXT
							 * flat_context,
							 _MOD_GL_VIEW_FLAT_GAME_CONTEXT_ARMIES
							 *
							 game_context_armies,
							 LW6KER_GAME_STATE *
							 game_state,
							 LW6GFX_GAME_LOOK *
							 game_look);

/*
 * in pick.c
 */
extern void _mod_gl_view_flat_pick_map_coord (MOD_GL_UTILS_CONTEXT *
					      utils_context,
					      _MOD_GL_VIEW_FLAT_CONTEXT *
					      flat_context,
					      int *map_x,
					      int *map_y,
					      LW6MAP_MAP * map,
					      LW6KER_GAME_STATE * game_state,
					      int screen_x, int screen_y);

/*
 * In setup.c
 */
extern _MOD_GL_VIEW_FLAT_CONTEXT
  * _mod_gl_view_flat_init (MOD_GL_UTILS_CONTEXT * utils_context);
extern void _mod_gl_view_flat_quit (MOD_GL_UTILS_CONTEXT * utils_context,
				    _MOD_GL_VIEW_FLAT_CONTEXT * flat_context);

#endif
