/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6KER_INTERNAL_H
#define LIQUIDWAR6KER_INTERNAL_H

#define _LW6KER_NB_STRAIGHT_DIRS 16
#define _LW6KER_STRAIGHT_DIR_UP 0x01;
#define _LW6KER_STRAIGHT_DIR_RIGHT 0x02;
#define _LW6KER_STRAIGHT_DIR_DOWN 0x04;
#define _LW6KER_STRAIGHT_DIR_LEFT 0x08;

extern LW6SYS_INT32 _LW6KER_TABLES_MOVE_X_OFFSET[LW6KER_NB_DIRS];
extern LW6SYS_INT32 _LW6KER_TABLES_MOVE_Y_OFFSET[LW6KER_NB_DIRS];
extern LW6SYS_INT32
  _LW6KER_TABLES_MOVE_DIR[LW6KER_NB_PARITIES][LW6KER_NB_DIRS]
  [LW6OPT_MAX_NB_DIR_TRIES];
extern LW6SYS_INT32
  _LW6KER_TABLES_STRAIGHT_DIRS[LW6KER_NB_PARITIES][_LW6KER_NB_STRAIGHT_DIRS];

/*
 * In armies.c
 */
extern LW6SYS_BOOL _lw6ker_armies_init (LW6KER_ARMIES * armies,
					LW6KER_MAP_STRUCT * map_struct,
					LW6OPT_STATIC * options);
extern void _lw6ker_armies_clear (LW6KER_ARMIES * armies);
extern LW6SYS_BOOL _lw6ker_armies_copy (LW6KER_ARMIES * dst,
					LW6KER_ARMIES * src);
extern void _lw6ker_armies_update_checksum (LW6KER_ARMIES * armies,
					    LW6SYS_UINT32 * checksum);

extern LW6SYS_BOOL _lw6ker_bot_init (LW6KER_BOT * bot, LW6KER_CURSOR * cursor,
				     LW6SYS_INT32 rounds);
extern void _lw6ker_bot_clear (LW6KER_BOT * bot);
extern void _lw6ker_bot_update_checksum (LW6KER_BOT * bot,
					 LW6SYS_UINT32 * checksum);
extern void _lw6ker_bot_update_pos (LW6KER_BOT * bot,
				    LW6KER_GAME_STATE * game_state);

/*
 * In cursor.c
 */
extern LW6SYS_BOOL _lw6ker_cursor_init (LW6KER_CURSOR * cursor,
					LW6SYS_XY pos);
extern void _lw6ker_cursor_update_checksum (LW6KER_CURSOR * cursor,
					    LW6SYS_UINT32 * checksum);
extern void _lw6ker_cursor_update_last_applied (LW6KER_CURSOR * cursor);

/*
 * In cursorarray.c
 */
extern void _lw6ker_cursor_array_update_checksum (LW6KER_CURSOR_ARRAY *
						  cursor_array,
						  LW6SYS_UINT32 * checksum);
extern void _lw6ker_cursor_array_activate (LW6KER_CURSOR_ARRAY * cursor_array,
					   LW6SYS_INT32 nb_cursors,
					   LW6SYS_XY pos);

/*
 * In fighter.c
 */
extern void _lw6ker_fighter_clear (LW6KER_FIGHTER * fighter);
extern void _lw6ker_fighter_update_checksum (LW6KER_FIGHTER * fighter,
					     LW6SYS_UINT32 * checksum);
extern void _lw6ker_fighter_print_debug (LW6KER_FIGHTER * fighter);
extern void _lw6ker_fighter_move (LW6KER_FIGHTER * fighter,
				  LW6SYS_INT32 fighter_id,
				  LW6SYS_INT32 layer, LW6SYS_INT32 x,
				  LW6SYS_INT32 y,
				  LW6KER_MAP_STATE * map_state);
extern void _lw6ker_fighter_attack (LW6KER_FIGHTER * fighter,
				    LW6SYS_INT32 fighter_id,
				    LW6SYS_INT32 layer, LW6SYS_INT32 x,
				    LW6SYS_INT32 y,
				    LW6KER_MAP_STATE * map_state,
				    LW6SYS_INT32 fighter_attack,
				    LW6SYS_INT32 fighter_new_health);
extern void _lw6ker_fighter_defend (LW6KER_FIGHTER * fighter,
				    LW6SYS_INT32 fighter_id,
				    LW6SYS_INT32 layer, LW6SYS_INT32 x,
				    LW6SYS_INT32 y,
				    LW6KER_MAP_STATE * map_state,
				    LW6SYS_INT32 fighter_defense);

/*
 * In gamestate.c
 */
extern void _lw6ker_game_state_update_checksum (LW6KER_GAME_STATE *
						game_state,
						LW6SYS_UINT32 * checksum);

/*
 * In gamestruct.c
 */
extern void _lw6ker_game_struct_update_checksum (LW6KER_GAME_STRUCT *
						 game_struct,
						 LW6SYS_UINT32 * checksum);

/*
 * In layer.c
 */
extern LW6SYS_BOOL _lw6ker_layer_init (LW6KER_LAYER * layer,
				       LW6KER_MAP_STRUCT * map_struct,
				       LW6KER_ARMIES * armies,
				       LW6OPT_STATIC * options);
extern void _lw6ker_layer_clear (LW6KER_LAYER * layer);
extern LW6SYS_BOOL _lw6ker_layer_copy (LW6KER_LAYER * dst,
				       LW6KER_LAYER * src);
extern void _lw6ker_layer_update_checksum (LW6KER_LAYER * layer,
					   LW6SYS_UINT32 * checksum);

/*
 * In map.c
 */
extern int _lw6ker_map_depth_rectangle (LW6MAP_DEPTH * depth, int width,
					int height);
extern int _lw6ker_map_metadata_rectangle (LW6MAP_METADATA * metadata,
					   int width, int height);


/*
 * in mapstate.c
 */
extern LW6SYS_BOOL _lw6ker_map_state_init (LW6KER_MAP_STATE * map_state,
					   LW6KER_MAP_STRUCT * map_struct,
					   LW6OPT_STATIC * options);
extern void _lw6ker_map_state_clear (LW6KER_MAP_STATE * map_state);
extern LW6SYS_BOOL _lw6ker_map_state_copy (LW6KER_MAP_STATE * dst,
					   LW6KER_MAP_STATE * src);
extern void _lw6ker_map_state_update_checksum (LW6KER_MAP_STATE * map_state,
					       LW6SYS_UINT32 * checksum);
extern LW6SYS_BOOL _lw6ker_map_state_is_slot_free (LW6KER_MAP_STATE *
						   map_state,
						   LW6SYS_INT32 layer,
						   LW6SYS_INT32 x,
						   LW6SYS_INT32 y);
extern LW6SYS_BOOL _lw6ker_map_state_is_enemy_there (LW6KER_MAP_STATE *
						     map_state,
						     LW6SYS_INT32 team_id,
						     LW6SYS_INT32 layer,
						     LW6SYS_INT32 x,
						     LW6SYS_INT32 y);

/*
 * In mapstruct.c
 */
extern LW6SYS_BOOL _lw6ker_map_struct_init (LW6KER_MAP_STRUCT * map_struct,
					    LW6MAP_MAP * map);
extern void _lw6ker_map_struct_clear (LW6KER_MAP_STRUCT * map_struct);
extern float _lw6ker_map_struct_get_compression (LW6KER_MAP_STRUCT *
						 map_struct);
extern void _lw6ker_map_struct_update_checksum (LW6KER_MAP_STRUCT *
						map_struct,
						LW6SYS_UINT32 * checksum);

/*
 * In slotstruct.c
 */
extern void _lw6ker_slot_struct_update_checksum (LW6KER_SLOT_STRUCT *
						 slot_struct,
						 LW6SYS_UINT32 * checksum);

/*
 * In team.c
 */
extern LW6SYS_BOOL _lw6ker_team_init (LW6KER_TEAM * team,
				      LW6KER_MAP_STRUCT * map_struct,
				      LW6OPT_STATIC * options);
extern void _lw6ker_team_clear (LW6KER_TEAM * team);
extern LW6SYS_BOOL _lw6ker_team_copy (LW6KER_TEAM * dst, LW6KER_TEAM * src);
extern void _lw6ker_team_update_checksum (LW6KER_TEAM * team,
					  LW6SYS_UINT32 * checksum);

/*
 * In slotstate.c
 */
extern void _lw6ker_slot_state_update_checksum (LW6KER_SLOT_STATE *
						slot_state,
						LW6SYS_UINT32 * checksum);

/*
 * In slotstruct.c
 */
extern void _lw6ker_slot_struct_update_checksum (LW6KER_SLOT_STRUCT *
						 slot_struct,
						 LW6SYS_UINT32 * checksum);

/*
 * In zonestate.c
 */
extern void _lw6ker_zone_state_update_checksum (LW6KER_ZONE_STATE *
						zone_state,
						LW6SYS_UINT32 * checksum);

/*
 * In zonestruct.c
 */
extern void _lw6ker_zone_struct_update_checksum (LW6KER_ZONE_STRUCT *
						 zone_struct,
						 LW6SYS_UINT32 * checksum);

#endif
