/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6MAP_INTERNAL_H
#define LIQUIDWAR6MAP_INTERNAL_H

typedef struct _LW6MAP_IMAGE_BW_STRUCT
{
  LW6SYS_WH shape;
  unsigned char **data;
  int step;
}
_LW6MAP_IMAGE_BW;

typedef struct _LW6MAP_IMAGE_RGBA_STRUCT
{
  LW6SYS_WH shape;
  unsigned char **data;
}
_LW6MAP_IMAGE_RGBA;


/*
 * In bw.c
 */
extern int _lw6map_bw_read (_LW6MAP_IMAGE_BW * image, char *png_file);
extern void _lw6map_bw_clear (_LW6MAP_IMAGE_BW * image);

/*
 * In rgba.c
 */
extern int _lw6map_rgba_read_png (_LW6MAP_IMAGE_RGBA * image, char *png_file);
extern int _lw6map_rgba_read_jpeg (_LW6MAP_IMAGE_RGBA * image,
				   char *jpeg_file);
extern void _lw6map_rgba_clear (_LW6MAP_IMAGE_RGBA * image);

#endif
