/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <locale.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

#define HTTPD_LOG_FILE "httpd.log"
#define HTTPD_LOG_TIME_SIZE 30

char *
lw6net_httpd_get_default_log ()
{
  char *dir = NULL;
  char *ret;

  dir = getenv ("HOME");
  if (!dir)
    {
      dir = ".";
    }

  ret = lw6sys_str_concat (dir, "/." PACKAGE_TARNAME "/" HTTPD_LOG_FILE);

  return ret;
}

void
lw6net_clear_log ()
{
  FILE *f = NULL;
  char *filename;

  filename = lw6net_httpd_get_default_log ();
  if (filename)
    {
      lw6sys_create_dir_for_file (filename);
      f = fopen (filename, "w");
      if (f)
	{
	  fclose (f);
	}
      LW6SYS_FREE (filename);
    }
}

static FILE *
open_default_log ()
{
  FILE *ret = NULL;
  char *name;

  name = lw6net_httpd_get_default_log ();
  if (name)
    {
      ret = fopen (name, "a");
      LW6SYS_FREE (name);
    }

  return ret;
}

/*
 * Example:
 * 127.0.0.1 - frank [10/Oct/2000:13:55:36 -0700] "GET /apache_pb.gif HTTP/1.0" 200 2326
 * http://httpd.apache.org/docs/1.3/logs.html#common
 */
int
_lw6net_httpd_log (_LW6NET_SERVER_HANDLE_DATA * handle_data,
		   _LW6NET_HTTPD_LOG_ENTRY * httpd_log_entry)
{
  int ret = 0;
  FILE *f = NULL;
  struct tm brokentime;
  time_t now;
  char *locale;
  char *old_locale;
  char time_buffer[HTTPD_LOG_TIME_SIZE];

  f = open_default_log ();
  if (f)
    {
      memset (time_buffer, 0, HTTPD_LOG_TIME_SIZE);
      now = time (NULL);
      if (!localtime_r (&now, &brokentime))
	{
	  memset (&brokentime, 0, sizeof (struct tm));
	}

      /*
       * We don't want localized months in httpd common log format,
       * so we fallback to default just for logging...
       */
      locale = setlocale (LC_ALL, NULL);
      if (locale)
	{
	  /*
	   * We do need to make a copy in a separate buffer,
	   * otherwise the content pointed by *locale
	   * might change dynamically when calling setlocale
	   */
	  old_locale = lw6sys_str_copy (locale);
	  setlocale (LC_ALL, "C");
	  strftime (time_buffer, HTTPD_LOG_TIME_SIZE - 1,
		    "%d/%b/%Y:%H:%M:%S %z", &brokentime);
	  setlocale (LC_ALL, old_locale);
	  if (old_locale)
	    {
	      LW6SYS_FREE (old_locale);
	    }
	}

      fprintf (f, "%s - %s [%s] \"%s\" %d %d\n", httpd_log_entry->ip,
	       httpd_log_entry->user, time_buffer, httpd_log_entry->request,
	       httpd_log_entry->status, httpd_log_entry->length);
      fclose (f);
      ret = 1;
    }

  return ret;
}
