/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <string.h>

#include "config.h"
#include "net.h"
#include "net-internal.h"

#define PROTOCOL_KEY_HTTP_GET "GET"
#define PROTOCOL_KEY_HTTP_HEAD "HEA"
#define PROTOCOL_KEY_HTTP_POST "POS"
#define PROTOCOL_KEY_LW6 "LW6"
#define PROTOCOL_KEY_SIZE 3

_LW6NET_PROTOCOL
_lw6net_get_protocol (_LW6NET_CONTEXT * context, int sock)
{
  _LW6NET_PROTOCOL ret;
  char buf[PROTOCOL_KEY_SIZE + 1];

  ret = _LW6NET_PROTOCOL_UNKNOWN;	// by default
  memset (buf, 0, PROTOCOL_KEY_SIZE + 1);
  if (lw6net_socket_peek
      ((void *) context, sock, buf, PROTOCOL_KEY_SIZE,
       context->const_data.protocol_delay))
    {
      lw6sys_str_cleanup (buf);
      if ((!strncmp (buf, PROTOCOL_KEY_HTTP_GET, PROTOCOL_KEY_SIZE)) ||
	  (!strncmp (buf, PROTOCOL_KEY_HTTP_HEAD, PROTOCOL_KEY_SIZE)) ||
	  (!strncmp (buf, PROTOCOL_KEY_HTTP_POST, PROTOCOL_KEY_SIZE)))
	{
	  ret = _LW6NET_PROTOCOL_HTTP;
	}
      else if (!strncmp (buf, PROTOCOL_KEY_LW6, PROTOCOL_KEY_SIZE))
	{
	  ret = _LW6NET_PROTOCOL_LW6;
	}
      else
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, "net",
		      _("unknown protocol, request starts with \"%s\""), buf);
	  ret = _LW6NET_PROTOCOL_ERROR;
	}
    }

  return ret;
}
