/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <signal.h>

#include "net.h"
#include "net-internal.h"

void *
lw6net_init ()
{
  _LW6NET_CONTEXT *net_context = NULL;
  int ok = 0;

  lw6sys_log (LW6SYS_LOG_INFO, "net", _("net init"));

  net_context = (_LW6NET_CONTEXT *) LW6SYS_CALLOC (sizeof (_LW6NET_CONTEXT));
  if (net_context)
    {
      /*
       * Well, it seems that SIGPIPE is sent to the application when
       * there's a brutal socket close or things like that, so we
       * just trap it and do nothing. Normally, the socket functions
       * should return an error anyway...
       */
      ok = (signal (SIGPIPE, SIG_IGN) != SIG_ERR);

      ok = _lw6net_const_init (net_context)
	&& _lw6net_socket_init (net_context)
	&& _lw6net_httpd_init (net_context)
	&& _lw6net_thread_init (net_context)
	&& _lw6net_screenshot_init (net_context) && ok;
    }

  if (!ok)
    {
      if (net_context)
	{
	  LW6SYS_FREE (net_context);
	  net_context = NULL;
	}
    }

  return (void *) net_context;
}

void
lw6net_quit (void *context)
{
  _LW6NET_CONTEXT *net_context = NULL;

  lw6sys_log (LW6SYS_LOG_INFO, "net", _("net quit"));

  net_context = (_LW6NET_CONTEXT *) context;
  if (net_context)
    {
      _lw6net_screenshot_quit (net_context);
      _lw6net_thread_quit (net_context);
      _lw6net_httpd_quit (net_context);
      _lw6net_socket_quit (net_context);
      _lw6net_const_quit (net_context);
      LW6SYS_FREE (net_context);
    }
}
