/*
Liquid War 6 is a unique multiplayer wargame.
Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.


Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6NET_H
#define LIQUIDWAR6NET_H

#include "../lw6-common.h"
#include "../sys/sys.h"
#include "../map/map.h"
#include "../ker/ker.h"

#define LW6NET_ADDRESS_ANY "0.0.0.0"
#define LW6NET_ADDRESS_LOOPBACK "127.0.0.1"

#define LW6NET_DEFAULT_PORT 8056
#define LW6NET_DEFAULT_SERVER_LAN "192.168.0.251"
#define LW6NET_DEFAULT_SERVER_WAN "ufoot.hd.free.fr"
#define LW6NET_DEFAULT_LIST "http://www.gnu.org/software/liquidwar6/list.txt"

/*
 * In httplog.c
 */
extern char *lw6net_httpd_get_default_log ();
extern void lw6net_clear_log ();

/*
 * In line.c
 */
extern char *lw6net_recv_line (void *context, int sock);
extern int lw6net_send_line (void *context, int sock, char *line);

/*
 * In screenshot.c
 **/
char *lw6net_screenshot_get_default_jpeg ();

/*
 * In setup.c
 */
extern void *lw6net_init ();
extern void lw6net_quit (void *net_context);

/*
 * In server.c
 */
extern int lw6net_server_start (void *net_context, char *ip, int port);
extern int lw6net_server_poll (void *net_context, LW6MAP_MAP * map,
			       LW6KER_GAME_STATE * game_state);
extern void lw6net_server_stop (void *net_context);

/*
 * In socket.c
 */
extern int lw6net_socket_listen (void *net_context, char *ip, int port);
extern int lw6net_socket_accept (void *net_context, char **incoming_ip,
				 int *incoming_port, int listening_sock,
				 float wait);
extern int lw6net_socket_connect (void *net_context, char *ip, int port);
extern void lw6net_socket_close (void *net_context, int sock);
extern void *lw6net_socket_async_connect_init (void *net_context, char *ip,
					       int port);
extern int lw6net_socket_async_connect_get (void *net_context, int *sock,
					    void *handler);
extern void lw6net_socket_async_connect_exit (void *net_context,
					      void *handler);
extern int lw6net_socket_send (void *net_context, int sock, char *buf,
			       int len, float delay, int loop);
extern int lw6net_socket_peek (void *net_context, int sock, char *buf,
			       int len, float delay);
extern int lw6net_socket_recv (void *net_context, int sock, char *buf,
			       int len, float delay, int loop);
extern int lw6net_socket_is_alive (void *net_context, int sock);

#endif
