/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "config.h"
#include "sys.h"

#define INT_BUFFER_SIZE 33

/*
 * A simple wrapper on atoi, provided just for API consistency.
 */
int
lw6sys_str2int (char *str)
{
  return atoi (str);
}

/*
 * Converts an integer to a string. Returned string must
 * be freed with LW6SYS_FREE.
 */
char *
lw6sys_int2str (int n)
{
  char *str = NULL;

  str = LW6SYS_MALLOC (INT_BUFFER_SIZE + 1);
  if (str)
    {
      snprintf (str, INT_BUFFER_SIZE + 1, "%d", n);
      str[INT_BUFFER_SIZE] = '\0';
    }

  return str;
}

/*
 * Returns 1 if str is "true" (the string). This is used
 * to handle options in config files.
 */
int
lw6sys_str2bool (char *str)
{
  return (strcmp (str, "true") == 0) ? 1 : 0;
}

/*
 * Converts an integer/boolean to a string which is
 * "true" or "false". Returned value must be freed
 * with LW6SYS_FREE. This is for API consistency
 * with int2str only.
 */
char *
lw6sys_bool2str (int b)
{
  char *str = NULL;

  if (b)
    {
      str = lw6sys_str_copy ("true");
    }
  else
    {
      str = lw6sys_str_copy ("false");
    }

  return str;
}
