/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdlib.h>
#include <string.h>

#include "config.h"
#include "sys.h"

/*
 * One of the rare global variables in the various Liquid War 6
 * libs, used to keep track of all calls to malloc & free, which
 * are by definition application wide.
 */
static int malloc_counter = 0;
static int free_counter = 0;

void *
lw6sys_malloc (int size, char *file, int line)
{
  void *ptr;

  ptr = malloc (size);

  if (ptr != NULL)
    {
      malloc_counter++;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("malloc %d bytes failed in %s:%d"), size, file, size);
    }

  return ptr;
}

/*
 * Same as lw6sys_malloc, but allocated buffer is filled with 0s.
 */
void *
lw6sys_calloc (int size, char *file, int line)
{
  void *ptr;

  ptr = calloc (size, sizeof (char));

  if (ptr != NULL)
    {
      malloc_counter++;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("calloc %d bytes failed in %s:%d"), size, file, size);
    }

  return ptr;
}

void
lw6sys_free (void *ptr, char *file, int line)
{
  if (ptr != NULL)
    {
      free (ptr);
      free_counter++;
    }
  else
    {
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _("trying to free null pointer in %s:%d"), file, line);
    }
}

void
lw6sys_free_callback (void *ptr)
{
  LW6SYS_FREE (ptr);
}

int
lw6sys_get_malloc_count ()
{
  return malloc_counter;
}

int
lw6sys_get_free_count ()
{
  return free_counter;
}

int
lw6sys_check_malloc_free_count ()
{
  int ret = 1;

  if (malloc_counter != free_counter)
    {
      ret = 0;
      lw6sys_log (LW6SYS_LOG_WARNING, "sys",
		  _
		  ("possible memory leak, %d calls to malloc and %d calls to free, note that if the program exited abnormally because of an unexpected error, this difference might be \"normal\""),
		  malloc_counter, free_counter);
    }

  return ret;
}
