;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-get-default-backend
  (lambda (get-backends-proc warning-msg) 
    (let (
	  (backends (get-backends-proc))
	  )
      (if (eqv? backends '())
	  (begin
	    (lw6-log-warning warning-msg)
	    ""
	    )
	  (caar backends)
       )
      )
    ))

(define lw6-get-default-gfx-backend
  (lambda () 
    (lw6-get-default-backend c-lw6gfx-get-backends 
			 (_ "no gfx backend found"))
    ))
      
(define lw6-get-default-snd-backend
  (lambda () 
    (lw6-get-default-backend c-lw6snd-get-backends 
			 (_ "no snd backend found"))
    ))
      
(define lw6-backend-exists?
  (lambda (get-backends-proc)
    (not (eqv? (get-backends-proc) '()))
    ))
      
(define lw6-gfx-backend-exists?
  (lambda ()
    (lw6-backend-exists? c-lw6gfx-get-backends)
    ))

(define lw6-snd-backend-exists?
  (lambda ()
    (lw6-backend-exists? c-lw6snd-get-backends)
    ))

