;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-config-set-string!
  (lambda (key value)
    (c-lw6cfg-set-option key value)
    )
  )

(define lw6-config-get-string
  (lambda (key)
    (c-lw6cfg-get-option key)
    )
  )

(define lw6-config-set-number!
  (lambda (key value)
    (begin
      (c-lw6cfg-set-option key (number->string value))
      )
    )
  )

(define lw6-config-get-number
  (lambda (key)
    (string->number (c-lw6cfg-get-option key))
    )
  )

(define lw6-config-set-boolean!
  (lambda (key value)
    (c-lw6cfg-set-option key (if value "true" "false"))
    )
  )

(define lw6-config-is-true?
  (lambda (key)
    (equal? (c-lw6cfg-get-option key) "true")
    )
  )

(define lw6-config-defaults
  (lambda ()
    (begin 
      (lw6-config-set-string! "user-dir" (c-lw6sys-get-user-dir))
      (lw6-config-set-string! "log-file" (c-lw6sys-get-log-file))
      (lw6-config-set-string! "map-path" "")
      (lw6-config-set-boolean! "fullscreen" #f)
      (lw6-config-set-boolean! "display-fps" #t)
      (lw6-config-set-number! "width" 640)
      (lw6-config-set-number! "height" 480)
      (lw6-config-set-number! "music-volume" 0.8)
      (lw6-config-set-number! "sound-volume" 0.8)
      (lw6-config-set-string! "player1-name" (c-lw6sys-get-username))
      (lw6-config-set-string! "player2-name" (string-join (list (_ "player2") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-string! "player3-name" (string-join (list (_ "player3") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-string! "player4-name" (string-join (list (_ "player4") 
								(c-lw6sys-get-hostname)) "@"))
      (lw6-config-set-number! "max-frames-per-sec" 60)
      (lw6-config-set-number! "max-logic-per-sec" 100)
      (lw6-config-set-number! "max-io-per-sec" 15)
      (lw6-config-set-number! "max-logic-per-display" 10)
      (lw6-config-set-number! "max-io-per-display" 2)
      (lw6-config-set-number! "checkpoint-period" 1000)
      (lw6-config-set-number! "loader-sleep" 0.1)
      (lw6-config-set-number! "memory-bazooka-size" 100)
      (lw6-config-set-boolean! "memory-bazooka-eraser" #t)
      (lw6-config-set-string! "chosen-map" "strange-new-world")
      (lw6-config-set-string! "background-style" "water")
      (lw6-config-set-string! "hud-style" "floating")
      (lw6-config-set-string! "menu-style" "cylinder")
      (lw6-config-set-string! "view-style" "flat")
      )
    )
  )

(define lw6-load-config 
  (lambda () 
    (begin
      (lw6-config-defaults)
      (c-lw6cfg-load (c-lw6sys-get-config-file))
      (c-lw6cfg-save (c-lw6sys-get-config-file))
      (c-lw6cfg-load (c-lw6sys-get-config-file))
      )
    )
  )

(define lw6-save-config 
  (lambda () 
    (begin
      (c-lw6cfg-save (c-lw6sys-get-config-file))
      )
    )
  )
