;Liquid War 6 is a unique multiplayer wargame.
;Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>
;
;This program is free software; you can redistribute it and/or modify
;it under the terms of the GNU General Public License as published by
;the Free Software Foundation, either version 3 of the License, or
;(at your option) any later version.
;
;This program is distributed in the hope that it will be useful,
;but WITHOUT ANY WARRANTY; without even the implied warranty of
;MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;GNU General Public License for more details.
;
;You should have received a copy of the GNU General Public License
;along with this program.  If not, see <http://www.gnu.org/licenses/>.
;
;
;Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
;Contact author        : ufoot@ufoot.org

(define lw6-root-menu-quick-start-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template (_ "Quick start")))
	  )
      (begin
	(assoc-set! item "selected" #t)
	item
	))))

(define lw6-root-menu-local-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template (_ "Local game")))
	  )
      (begin
	(assoc-set! item "selected" #f)
	item
	))))

(define lw6-root-menu-network-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template (_ "Network game")))
	  )
      (begin
	(assoc-set! item "selected" #f)
	item
	))))

(define lw6-root-menu-map-item
  (lambda ()
    (let (
	  (item (lw6-menu-item-template (_ "Choose map")))
	  )
      (begin
	(assoc-set! item "selected" #f)
	(assoc-set! item "on-valid" (lambda () (lw6-push-menu (lw6-map-menu (lw6-config-get-string "chosen-map")))))
	item
	))))

(define lw6-root-menu
  (lambda()
    (let (
	  (menu (lw6-menu-template (_ "Welcome to Liquid War 6")))
	  )
      (begin
	(lw6-append-menuitem! menu (lw6-root-menu-quick-start-item))
	(lw6-append-menuitem! menu (lw6-root-menu-local-item))
	(lw6-append-menuitem! menu (lw6-root-menu-network-item))
	(lw6-append-menuitem! menu (lw6-root-menu-map-item))
	(assoc-set! menu "on-cancel" (lambda () (lw6-push-menu (lw6-exit-menu))))
	menu
	))))
