
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "cli.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("cli backend function \"%s\" is not defined"), func_name);
}

int
lw6cli_init (lw6cli_backend_t * backend)
{
  if (backend->init)
    {
      backend->cli_context = backend->init (backend->argc, backend->argv);
    }
  else
    {
      warning ("init");
    }

  return backend->cli_context ? 1 : 0;
}

void
lw6cli_quit (lw6cli_backend_t * backend)
{
  if (backend->quit)
    {
      backend->quit (backend->cli_context);
      backend->cli_context = NULL;
    }
  else
    {
      warning ("quit");
    }
}

int
lw6cli_can_handle (lw6cli_backend_t * backend, char *server_url)
{
  int ret = 0;

  if (backend->can_handle)
    {
      ret = backend->can_handle (backend->cli_context, server_url);
    }
  else
    {
      warning ("can_handle");
    }

  return ret;
}

lw6cli_connection_t *
lw6cli_connect (lw6cli_backend_t * backend, char *server_url,
		char *client_url, char *password)
{
  lw6cli_connection_t *ret = NULL;

  if (backend->connect)
    {
      ret =
	backend->connect (backend->cli_context, server_url, client_url,
			  password);
    }
  else
    {
      warning ("connect");
    }

  return ret;
}

void
lw6cli_close (lw6cli_backend_t * backend, lw6cli_connection_t * connection)
{
  if (backend->close)
    {
      backend->close (backend->cli_context, connection);
    }
  else
    {
      warning ("close");
    }
}

int
lw6cli_send (lw6cli_backend_t * backend, lw6cli_connection_t * connection,
	     char *message)
{
  int ret = 0;

  if (backend->send)
    {
      ret = backend->send (backend->cli_context, connection, message);
    }
  else
    {
      warning ("send");
    }

  return ret;
}

char *
lw6cli_recv (lw6cli_backend_t * backend, lw6cli_connection_t * connection)
{
  char *ret = NULL;

  if (backend->recv)
    {
      ret = backend->recv (backend->cli_context, connection);
    }
  else
    {
      warning ("recv");
    }

  return ret;
}

int
lw6cli_is_alive (lw6cli_backend_t * backend, lw6cli_connection_t * connection)
{
  int ret = 0;

  if (backend->is_alive)
    {
      ret = backend->is_alive (backend->cli_context, connection);
    }
  else
    {
      warning ("is_alive");
    }

  return ret;
}

char *
lw6cli_repr (lw6cli_backend_t * backend, lw6cli_connection_t * connection)
{
  char *ret = NULL;

  if (backend->repr)
    {
      ret = backend->repr (backend->cli_context, connection);
    }
  else
    {
      warning ("repr");
    }

  return ret;
}

char *
lw6cli_error (lw6cli_backend_t * backend, lw6cli_connection_t * connection)
{
  char *ret = NULL;

  if (backend->error)
    {
      ret = backend->error (backend->cli_context, connection);
    }
  else
    {
      warning ("error");
    }

  return ret;
}
