/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "cli.h"

#define TEST_ARGC 1
#define TEST_ARGV0 "prog"

static int
test_init (lw6cli_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  {
    ret = ret && lw6cli_init (backend);
  }

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

static int
test_quit (lw6cli_backend_t * backend)
{
  int ret = 1;
  LW6SYS_TEST_FUNCTION_BEGIN;

  lw6cli_quit (backend);

  LW6SYS_TEST_FUNCTION_END;
  return ret;
}

int
lw6cli_test ()
{
  int ret = 1;
  lw6cli_backend_t *backend;
  int argc = TEST_ARGC;
  char *argv[TEST_ARGC] = { TEST_ARGV0 };

  if (lw6sys_false ())
    {
      /*
       * Just to make sure most functions are stuffed in the binary
       */
      lw6sys_test ();
      lw6cfg_test ();
      lw6net_test ();
    }

  backend = lw6cli_create_backend (argc, argv, "tcp");
  if (backend)
    {
      ret = test_init (backend) && test_quit (backend) && ret;
      lw6cli_destroy_backend (backend);
    }

  backend = lw6cli_create_backend (argc, argv, "udp");
  if (backend)
    {
      ret = test_init (backend) && test_quit (backend) && ret;
      lw6cli_destroy_backend (backend);
    }

  backend = lw6cli_create_backend (argc, argv, "http");
  if (backend)
    {
      ret = test_init (backend) && test_quit (backend) && ret;
      lw6cli_destroy_backend (backend);
    }

  return ret;
}
