/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "../cli.h"
#include "mod-udp.h"
#include "mod-udp-internal.h"

static void *
init ()
{
  _udp_context_t *udp_context = _mod_udp_init ();

  return (void *) udp_context;
}

static void
quit (void *cli_context)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;

  if (udp_context)
    {
      _mod_udp_quit (udp_context);
    }
}

static int
can_handle (void *cli_context, char *server_url)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  int ret = 0;

  if (udp_context)
    {
      ret = _mod_udp_can_handle (udp_context, server_url);
    }

  return ret;
}

static lw6cli_connection_t *
connect (void *cli_context, char *server_url, char *client_url,
	 char *password)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  lw6cli_connection_t *ret = NULL;

  if (udp_context)
    {
      ret = _mod_udp_connect (udp_context, server_url, client_url, password);
    }

  return ret;
}

static void
close (void *cli_context, lw6cli_connection_t * connection)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;

  if (udp_context)
    {
      _mod_udp_close (udp_context, connection);
    }
}

static int
send (void *cli_context, lw6cli_connection_t * connection, char *message)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  int ret = 0;

  if (udp_context)
    {
      ret = _mod_udp_send (udp_context, connection, message);
    }

  return ret;
}

static char *
recv (void *cli_context, lw6cli_connection_t * connection)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  char *ret = NULL;

  if (udp_context)
    {
      ret = _mod_udp_recv (udp_context, connection);
    }

  return ret;
}

static int
is_alive (void *cli_context, lw6cli_connection_t * connection)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  int ret = 0;

  if (udp_context)
    {
      ret = _mod_udp_is_alive (udp_context, connection);
    }

  return ret;
}

static char *
repr (void *cli_context, lw6cli_connection_t * connection)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  char *ret = NULL;

  if (udp_context)
    {
      ret = _mod_udp_repr (udp_context, connection);
    }

  return ret;
}

static char *
error (void *cli_context, lw6cli_connection_t * connection)
{
  _udp_context_t *udp_context = (_udp_context_t *) cli_context;
  char *ret = NULL;

  if (udp_context)
    {
      ret = _mod_udp_error (udp_context, connection);
    }

  return ret;
}

lw6cli_backend_t *
mod_udp_create_backend ()
{
  lw6cli_backend_t *backend;

  backend = LW6SYS_MALLOC (sizeof (lw6cli_backend_t));
  if (backend)
    {
      memset (backend, 0, sizeof (lw6cli_backend_t));

      backend->init = init;
      backend->quit = quit;
      backend->can_handle = can_handle;
      backend->connect = connect;
      backend->close = close;
      backend->send = send;
      backend->recv = recv;
      backend->is_alive = is_alive;
      backend->repr = repr;
      backend->error = error;
    }

  return backend;
}
