/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>
#include <readline/readline.h>

#include "config.h"
#include "cns.h"

#define PROMPT "lw6> "

void
lw6cns_handler_install (void (*callback) (char *line))
{
  lw6sys_log (LW6SYS_LOG_INFO, _("opening console"));

  rl_set_keyboard_input_timeout (1);
  rl_callback_handler_install (PROMPT, callback);
}

void
lw6cns_handler_poll ()
{
  fd_set rfds;
  struct timeval tv;
  int retval = 1;
  int c;

  /*
   * It's important to have a while here, for characters
   * are read one by one, and input could be slowed if
   * we had a simple "if".
   */
  while (retval)
    {
      FD_ZERO (&rfds);
      FD_SET (0, &rfds);	// stdin == fd 0

      tv.tv_sec = 0;
      tv.tv_usec = 0;

      retval = select (1, &rfds, NULL, NULL, &tv);

      if (retval > 0 && FD_ISSET (0, &rfds) && !feof (stdin))
	{
	  c = fgetc (stdin);
	  ungetc (c, stdin);
	  rl_callback_read_char ();
	}
    }
}

void
lw6cns_handler_remove ()
{
  rl_callback_handler_remove ();
  fprintf (stdout, "\n");
  fflush (stdout);

  lw6sys_log (LW6SYS_LOG_INFO, _("console closed"));
}
