/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "gfx.h"

static void
warning (char *func_name)
{
  lw6sys_log (LW6SYS_LOG_WARNING,
	      _("gfx backend function \"%s\" is not defined"), func_name);
}

void
lw6gfx_display_background (lw6gfx_backend_t * backend, lw6gui_look_t * look)
{
  if (backend->display_background)
    {
      backend->display_background (backend->gfx_context, look);
    }
  else
    {
      warning ("display_background");
    }
}

void
lw6gfx_display_hud (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		    lw6ker_game_state_t * game_state)
{
  if (backend->display_hud)
    {
      backend->display_hud (backend->gfx_context, look, game_state);
    }
  else
    {
      warning ("display_hud_fg");
    }
}

int
lw6gfx_poll_key (lw6gfx_backend_t * backend, lw6gui_keypress_t * keypress)
{
  int ret = 0;

  if (backend->poll_key)
    {
      ret = backend->poll_key (backend->gfx_context, keypress);
    }
  else
    {
      warning ("poll_key");
    }

  return ret;
}

int
lw6gfx_is_key_esc (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_esc)
    {
      ret = backend->is_key_esc (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_esc");
    }

  return ret;
}

int
lw6gfx_is_key_enter (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_enter)
    {
      ret = backend->is_key_enter (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_enter");
    }

  return ret;
}

int
lw6gfx_is_key_up (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_up)
    {
      ret = backend->is_key_up (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_up");
    }

  return ret;
}

int
lw6gfx_is_key_down (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_down)
    {
      ret = backend->is_key_down (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_down");
    }

  return ret;
}

int
lw6gfx_is_key_left (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_left)
    {
      ret = backend->is_key_left (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_left");
    }

  return ret;
}

int
lw6gfx_is_key_right (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->is_key_right)
    {
      ret = backend->is_key_right (backend->gfx_context, keysym);
    }
  else
    {
      warning ("is_key_right");
    }

  return ret;
}

int
lw6gfx_poll_quit (lw6gfx_backend_t * backend)
{
  int ret = 0;

  if (backend->poll_quit)
    {
      ret = backend->poll_quit (backend->gfx_context);
    }
  else
    {
      warning ("poll_quit");
    }

  return ret;
}

void
lw6gfx_send_quit (lw6gfx_backend_t * backend)
{
  if (backend->send_quit)
    {
      backend->send_quit (backend->gfx_context);
    }
  else
    {
      warning ("send_quit");
    }
}

int
lw6gfx_get_key_state (lw6gfx_backend_t * backend, int keysym)
{
  int ret = 0;

  if (backend->get_key_state)
    {
      ret = backend->get_key_state (backend->gfx_context, keysym);
    }
  else
    {
      warning ("get_key_state");
    }

  return ret;
}

int
lw6gfx_poll_mouse_move (lw6gfx_backend_t * backend, int *x, int *y)
{
  int ret = 0;

  if (backend->poll_mouse_move)
    {
      ret = backend->poll_mouse_move (backend->gfx_context, x, y);
    }
  else
    {
      warning ("poll_mouse_move");
    }

  return ret;
}

int
lw6gfx_poll_mouse_button_left (lw6gfx_backend_t * backend)
{
  int ret = 0;

  if (backend->poll_mouse_button_left)
    {
      ret = backend->poll_mouse_button_left (backend->gfx_context);
    }
  else
    {
      warning ("poll_mouse_button_left");
    }

  return ret;
}

int
lw6gfx_poll_mouse_button_right (lw6gfx_backend_t * backend)
{
  int ret = 0;

  if (backend->poll_mouse_button_right)
    {
      ret = backend->poll_mouse_button_right (backend->gfx_context);
    }
  else
    {
      warning ("poll_mouse_button_right");
    }

  return ret;
}

int
lw6gfx_poll_mouse_wheel_up (lw6gfx_backend_t * backend)
{
  int ret = 0;

  if (backend->poll_mouse_wheel_up)
    {
      ret = backend->poll_mouse_wheel_up (backend->gfx_context);
    }
  else
    {
      warning ("poll_mouse_wheel_up");
    }

  return ret;
}

int
lw6gfx_poll_mouse_wheel_down (lw6gfx_backend_t * backend)
{
  int ret = 0;

  if (backend->poll_mouse_wheel_down)
    {
      ret = backend->poll_mouse_wheel_down (backend->gfx_context);
    }
  else
    {
      warning ("poll_mouse_wheel_down");
    }

  return ret;
}

void
lw6gfx_get_mouse_state (lw6gfx_backend_t * backend, int *x, int *y,
			int *button_left, int *button_right)
{
  if (backend->get_mouse_state)
    {
      backend->get_mouse_state (backend->gfx_context, x, y, button_left,
				button_right);
    }
  else
    {
      warning ("get_mouse_state");
    }
}

int
lw6gfx_poll_joystick_up (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  if (backend->poll_joystick_up)
    {
      ret = backend->poll_joystick_up (backend->gfx_context, i);
    }
  else
    {
      warning ("poll_joystick_up");
    }

  return ret;
}

int
lw6gfx_poll_joystick_down (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  if (backend->poll_joystick_down)
    {
      ret = backend->poll_joystick_down (backend->gfx_context, i);
    }
  else
    {
      warning ("poll_joystick_down");
    }

  return ret;
}

int
lw6gfx_poll_joystick_left (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  if (backend->poll_joystick_left)
    {
      ret = backend->poll_joystick_left (backend->gfx_context, i);
    }
  else
    {
      warning ("poll_joystick_left");
    }

  return ret;
}

int
lw6gfx_poll_joystick_right (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  if (backend->poll_joystick_right)
    {
      ret = backend->poll_joystick_right (backend->gfx_context, i);
    }
  else
    {
      warning ("poll_joystick_right");
    }

  return ret;
}

int
lw6gfx_poll_joystick_button_a (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  if (backend->poll_joystick_button_a)
    {
      ret = backend->poll_joystick_button_a (backend->gfx_context, i);
    }
  else
    {
      warning ("poll_joystick_button_a");
    }

  return ret;
}

int
lw6gfx_poll_joystick_button_b (lw6gfx_backend_t * backend, int i)
{
  int ret = 0;

  if (backend->poll_joystick_button_b)
    {
      ret = backend->poll_joystick_button_b (backend->gfx_context, i);
    }
  else
    {
      warning ("poll_joystick_button_b");
    }

  return ret;
}

void
lw6gfx_get_joystick_state (lw6gfx_backend_t * backend, int *x, int *y,
			   int *button_a, int *button_b, int i)
{
  if (backend->get_joystick_state)
    {
      backend->get_joystick_state (backend->gfx_context, x, y, button_a,
				   button_b, i);
    }
  else
    {
      warning ("get_joystick_state");
    }
}

void
lw6gfx_display_log (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		    char **log_list)
{
  if (backend->display_log)
    {
      backend->display_log (backend->gfx_context, look, log_list);
    }
  else
    {
      warning ("display_log");
    }
}
void
lw6gfx_display_fps (lw6gfx_backend_t * backend, lw6gui_look_t * look, int fps)
{
  if (backend->display_fps)
    {
      backend->display_fps (backend->gfx_context, look, fps);
    }
  else
    {
      warning ("display_fps");
    }
}
void
lw6gfx_display_map_preview (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			    lw6map_level_t * level)
{
  if (backend->display_map_preview)
    {
      backend->display_map_preview (backend->gfx_context, look, level);
    }
  else
    {
      warning ("display_map_preview");
    }
}

void
lw6gfx_display_map_zones (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			  lw6ker_game_struct_t * game_struct)
{
  if (backend->display_map_zones)
    {
      backend->display_map_zones (backend->gfx_context, look, game_struct);
    }
  else
    {
      warning ("display_map_zones");
    }
}

void
lw6gfx_display_map_gradient (lw6gfx_backend_t * backend, lw6gui_look_t * look,
			     lw6ker_game_state_t * game_state, int team_id)
{
  if (backend->display_map_gradient)
    {
      backend->display_map_gradient (backend->gfx_context, look, game_state,
				     team_id);
    }
  else
    {
      warning ("display_map_gradient");
    }
}

void
lw6gfx_display_game (lw6gfx_backend_t * backend,
		     lw6gui_look_t * look, lw6ker_game_state_t * game_state)
{
  if (backend->display_game)
    {
      backend->display_game (backend->gfx_context, look, game_state);
    }
  else
    {
      warning ("display_game");
    }
}

void
lw6gfx_pick_map_coord (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		       int *map_x, int *map_y,
		       lw6ker_game_state_t * game_state, int screen_x,
		       int screen_y)
{
  if (backend->pick_map_coord)
    {
      backend->pick_map_coord (backend->gfx_context, look, map_x, map_y,
			       game_state, screen_x, screen_y);
    }
  else
    {
      warning ("pick_map_coord");
    }
}

void
lw6gfx_display_menu (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		     lw6gui_menu_t * menu)
{
  if (backend->display_menu)
    {
      backend->display_menu (backend->gfx_context, look, menu);
    }
  else
    {
      warning ("display_menu");
    }
}

void
lw6gfx_pick_menuitem (lw6gfx_backend_t * backend, lw6gui_look_t * look,
		      int *position, int *scroll, lw6gui_menu_t * menu,
		      int screen_x, int screen_y)
{
  if (backend->pick_menuitem)
    {
      backend->pick_menuitem (backend->gfx_context, look, position, scroll,
			      menu, screen_x, screen_y);
    }
  else
    {
      warning ("pick_menuitem");
    }
}

int
lw6gfx_warp_mouse_on_menuitem (lw6gfx_backend_t * backend,
			       lw6gui_look_t * look, lw6gui_menu_t * menu,
			       int position)
{
  int ret = 0;

  if (backend->warp_mouse_on_menuitem)
    {
      ret = backend->warp_mouse_on_menuitem (backend->gfx_context, look, menu,
					     position);
    }
  else
    {
      warning ("warp_mouse_on_menuitem");
    }

  return ret;
}

void
lw6gfx_prepare_buffer (lw6gfx_backend_t * backend, lw6gui_look_t * look)
{
  if (backend->prepare_buffer)
    {
      backend->prepare_buffer (backend->gfx_context, look);
    }
  else
    {
      warning ("prepare_buffer");
    }
}
void
lw6gfx_swap_buffers (lw6gfx_backend_t * backend)
{
  if (backend->swap_buffers)
    {
      backend->swap_buffers (backend->gfx_context);
    }
  else
    {
      warning ("swap_buffers");
    }
}
int
lw6gfx_init (lw6gfx_backend_t * backend, int width,
	     int height, int fullscreen,
	     void (*resize_callback) (int width, int height, int fullscreen),
	     int ticks)
{
  if (backend->init)
    {
      backend->gfx_context =
	backend->init (backend->argc, backend->argv, width, height,
		       fullscreen, resize_callback, ticks);
    }
  else
    {
      warning ("init");
    }

  return backend->gfx_context ? 1 : 0;
}

int
lw6gfx_set_video_mode (lw6gfx_backend_t * backend, int width, int height,
		       int fullscreen, void (*resize_callback) (int width,
								int height,
								int
								fullscreen))
{
  int ret = 0;

  if (backend->set_video_mode)
    {
      ret =
	backend->set_video_mode (backend->gfx_context, width, height,
				 fullscreen, resize_callback);
    }
  else
    {
      warning ("set_video_mode");
    }

  return ret;
}

int
lw6gfx_get_video_mode (lw6gfx_backend_t * backend, int *width, int *height,
		       int *fullscreen)
{
  int ret = 0;

  if (backend->get_video_mode)
    {
      ret =
	backend->get_video_mode (backend->gfx_context, width, height,
				 fullscreen);
    }
  else
    {
      warning ("get_video_mode");
    }

  return ret;
}

void
lw6gfx_quit (lw6gfx_backend_t * backend)
{
  if (backend->quit)
    {
      backend->quit (backend->gfx_context);
      backend->gfx_context = NULL;
    }
  else
    {
      warning ("quit");
    }
}
void
lw6gfx_delay (lw6gfx_backend_t * backend, int ms)
{
  if (backend->delay)
    {
      backend->delay (backend->gfx_context, ms);
    }
  else
    {
      warning ("delay");
    }
}
int
lw6gfx_get_ticks (lw6gfx_backend_t * backend)
{
  int ret = 0;

  if (backend->get_ticks)
    {
      ret = backend->get_ticks (backend->gfx_context);
    }
  else
    {
      warning ("get_ticks");
    }

  return ret;
}
