/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <GL/glu.h>

#include "config.h"
#include "../../mod-gl.h"
#include "gl-tactical-internal.h"

static void
set_texture_options (mod_gl_utils_context_t * utils_context,
		     _mod_gl_hud_tactical_context_t * tactical_context)
{
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri (GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
}

static void
display_frame (mod_gl_utils_context_t * utils_context,
	       _mod_gl_hud_tactical_context_t * tactical_context)
{
  float scale_w, scale_h;

  scale_w =
    mod_gl_utils_texture_scale (tactical_context->image_data.frame->w);
  scale_h =
    mod_gl_utils_texture_scale (tactical_context->image_data.frame->h);

  mod_gl_utils_set_render_mode_2d_blend (utils_context);

  glBindTexture (GL_TEXTURE_2D, tactical_context->texture_data.frame);
  set_texture_options (utils_context, tactical_context);

  glMatrixMode (GL_TEXTURE);
  glPushMatrix ();
  glLoadIdentity ();
  glBegin (GL_QUADS);
  glTexCoord2d (0.0f, 0.0f);
  glVertex3f (0.0f, 0.0f, 0.0f);	// top left
  glTexCoord2d (scale_w, 0.0f);
  glVertex3f (utils_context->screen.width, 0.0f, 0.0f);	// top right
  glTexCoord2d (scale_w, scale_h);
  glVertex3f (utils_context->screen.width, utils_context->screen.height, 0.0f);	// bottom right
  glTexCoord2d (0.0f, scale_h);
  glVertex3f (0.0f, utils_context->screen.height, 0.0f);	// bottom left
  glEnd ();

  glMatrixMode (GL_TEXTURE);
  glPopMatrix ();
}


void
_mod_gl_hud_tactical_display (mod_gl_utils_context_t * utils_context,
			      _mod_gl_hud_tactical_context_t *
			      tactical_context,
			      lw6gui_look_t * look,
			      lw6ker_game_state_t * game_state)
{
  display_frame (utils_context, tactical_context);
}

void
mod_gl_hud_tactical_display (mod_gl_utils_context_t * utils_context,
			     void *hud_context,
			     lw6gui_look_t * look,
			     lw6ker_game_state_t * game_state)
{
  _mod_gl_hud_tactical_display (utils_context,
				(_mod_gl_hud_tactical_context_t *)
				hud_context, look, game_state);
}
