
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>
#include <GL/glu.h>
#include <SDL/SDL_image.h>

#include "config.h"
#include "../../../gfx.h"
#include "../../../../cfg/cfg.h"
#include "gl-cylinder.h"
#include "gl-cylinder-internal.h"

#define CONST_FILE "menu/cylinder/gl-cylinder-const.xml"

static void
read_callback (void *callback_data, char *element, char *key, char *value)
{
  _mod_gl_menu_cylinder_const_data_t *const_data;

  const_data = (_mod_gl_menu_cylinder_const_data_t *) callback_data;

  if (!strcmp (element, "int"))
    {
      lw6cfg_read_xml_int (key, value, "max-displayed-items",
			   &const_data->max_displayed_items);
      lw6cfg_read_xml_int (key, value, "slices1", &const_data->slices1);
      lw6cfg_read_xml_int (key, value, "slices_min", &const_data->slices_min);
      lw6cfg_read_xml_int (key, value, "stacks", &const_data->stacks);
      lw6cfg_read_xml_int (key, value, "oscil-period",
			   &const_data->oscil_period);
      lw6cfg_read_xml_int (key, value, "nb-spheres", &const_data->nb_spheres);
      lw6cfg_read_xml_int (key, value, "sphere-slices1",
			   &const_data->sphere_slices1);
      lw6cfg_read_xml_int (key, value, "sphere-slices-min",
			   &const_data->sphere_slices_min);
      lw6cfg_read_xml_int (key, value, "sphere-blink-period",
			   &const_data->sphere_blink_period);
    }

  if (!strcmp (element, "float"))
    {
      lw6cfg_read_xml_float (key, value, "radius1", &const_data->radius1);
      lw6cfg_read_xml_float (key, value, "between1", &const_data->between1);
      lw6cfg_read_xml_float (key, value, "height", &const_data->height);
      lw6cfg_read_xml_float (key, value, "oscil-range1",
			     &const_data->oscil_range1);
      lw6cfg_read_xml_float (key, value, "rotate-offset",
			     &const_data->rotate_offset);
      lw6cfg_read_xml_float (key, value, "sphere-radius1",
			     &const_data->sphere_radius1);
      lw6cfg_read_xml_float (key, value, "sphere-between1",
			     &const_data->sphere_between1);
    }
}

static int
load_consts (mod_gl_utils_context_t * utils_context,
	     _mod_gl_menu_cylinder_context_t * cylinder_context)
{
  int ret = 0;
  char *const_file = NULL;

  const_file = lw6sys_path_concat (utils_context->path.data_dir, CONST_FILE);

  if (const_file)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("reading \"%s\""), const_file);

      ret =
	lw6cfg_read_key_value_xml_file (const_file, read_callback,
					(void *) &(cylinder_context->
						   const_data));

      LW6SYS_FREE (const_file);
    }

  return ret;
}

static void
unload_consts (mod_gl_utils_context_t * utils_context,
	       _mod_gl_menu_cylinder_context_t * cylinder_context)
{
  memset (&cylinder_context->const_data, 0,
	  sizeof (_mod_gl_menu_cylinder_const_data_t));
}

/*
 * Putting all the load/unload functions together
 */
int
_mod_gl_menu_cylinder_load_data (mod_gl_utils_context_t * utils_context,
				 _mod_gl_menu_cylinder_context_t *
				 cylinder_context)
{
  return load_consts (utils_context, cylinder_context);
}

int
mod_gl_menu_load_data (mod_gl_utils_context_t * utils_context,
		       void *cylinder_context)
{
  return _mod_gl_menu_cylinder_load_data (utils_context,
					  (_mod_gl_menu_cylinder_context_t *)
					  cylinder_context);
}

void
_mod_gl_menu_cylinder_unload_data (mod_gl_utils_context_t * utils_context,
				   _mod_gl_menu_cylinder_context_t *
				   cylinder_context)
{
  unload_consts (utils_context, cylinder_context);
}

void
mod_gl_menu_unload_data (mod_gl_utils_context_t * utils_context,
			 void *cylinder_context)
{
  _mod_gl_menu_cylinder_unload_data (utils_context,
				     (_mod_gl_menu_cylinder_context_t *)
				     cylinder_context);
}
