
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <math.h>
#include <GL/glu.h>

#include "config.h"
#include "../../mod-gl.h"
#include "gl-cylinder-internal.h"

// only 3 needed, but well, 4 won't harm
#define WARP_BUFFER_SIZE 4

static void
draw_point_x_y_z (float x, float y, float z)
{
  glMatrixMode (GL_MODELVIEW);
  glPushMatrix ();
  glLoadIdentity ();
  glTranslatef (x, y, z);
  glBegin (GL_POINT);
  glVertex3f (0, 0, 0);
  glEnd ();
  glMatrixMode (GL_MODELVIEW);
  glPopMatrix ();
}

int
_mod_gl_menu_cylinder_warp_mouse_on_menuitem (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_menu_cylinder_context_t
					      * cylinder_context,
					      lw6gui_look_t * look,
					      lw6gui_menu_t * menu,
					      int position)
{
  int ret = 0;
  int n, i;
  float y;
  GLfloat feedback_buffer[WARP_BUFFER_SIZE];
  int feedback_size = 0;
  float mouse_x, mouse_y;

  lw6gui_menu_update_display_range (menu,
				    cylinder_context->const_data.
				    max_displayed_items);

  memset (feedback_buffer, 0, sizeof (GLfloat) * WARP_BUFFER_SIZE);
  mod_gl_utils_set_render_mode_3d_warp (utils_context);

  n = menu->nb_items_displayed + 2;
  i = position - menu->first_item_displayed + 1;

  if (i >= 1 && i < n - 1)
    {
      y =
	_mod_gl_menu_cylinder_get_cylinder_y (utils_context, cylinder_context,
					      i, n);

      glFeedbackBuffer (WARP_BUFFER_SIZE, GL_2D, feedback_buffer);
      glRenderMode (GL_FEEDBACK);
      draw_point_x_y_z (0, y, -1.0f);
      feedback_size = glRenderMode (GL_FEEDBACK);

      if (feedback_size >= WARP_BUFFER_SIZE)
	{
	  lw6sys_log (LW6SYS_LOG_WARNING, _("warp buffer overflow (%d)"),
		      feedback_size);
	}
      else if (feedback_size >= 2)
	{
	  mouse_x = feedback_buffer[feedback_size - 2];
	  mouse_y = feedback_buffer[feedback_size - 1];
	  if (mouse_x >= 1 && mouse_x < utils_context->screen.width - 1
	      && mouse_y >= 1 && mouse_y < utils_context->screen.height - 1)
	    {
	      SDL_WarpMouse (mouse_x, utils_context->screen.height - mouse_y);
	      utils_context->mouse_state.x = mouse_x;
	      utils_context->mouse_state.y =
		utils_context->screen.height - mouse_y;
	    }
	}
    }

  return ret;
}

int
mod_gl_menu_cylinder_warp_mouse_on_menuitem (mod_gl_utils_context_t *
					     utils_context,
					     void *cylinder_context,
					     lw6gui_look_t * look,
					     lw6gui_menu_t * menu,
					     int position)
{
  return _mod_gl_menu_cylinder_warp_mouse_on_menuitem (utils_context,
						       (_mod_gl_menu_cylinder_context_t
							*) cylinder_context,
						       look, menu, position);
}
