/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

SDL_Color
mod_gl_utils_color_8_to_sdl (lw6sys_color_8_t color_8)
{
  SDL_Color ret;

  ret.r = color_8.r;
  ret.g = color_8.g;
  ret.b = color_8.b;
  ret.unused = 0;

  return ret;
}

SDL_Color
mod_gl_utils_color_f_to_sdl (lw6sys_color_f_t * color_f)
{
  lw6sys_color_8_t color_8;
  SDL_Color ret;

  color_8 = lw6sys_color_f_to_8 (color_f);
  ret = mod_gl_utils_color_8_to_sdl (color_8);

  return ret;
}

static Uint32
prepare_shaded_color_for_fighter (Uint32 color, int j)
{
  Uint32 ret = 0xFFFFFFFF;	// alpha must be 0xFF
  unsigned char *p_src;
  unsigned char *p_dst;
  unsigned char c;
  int i;

  p_src = (unsigned char *) &color;
  p_dst = (unsigned char *) &ret;

  /*
   * Slow but we don't care, executed at startup.
   */
  for (i = 0; i < sizeof (Uint32) - 1; ++i)
    {
      c =
	(((unsigned int) (*(p_src + i))) * j) /
	MOD_GL_SHADES_FOR_FIGHTERS_SCALE;
      (*(p_dst + i)) = c;
    }

  return ret;
}

Uint32
get_team_color (lw6map_style_t * map_style, int id)
{
  Uint32 ret;

  ret = lw6sys_color_8_to_i (map_style->team_colors[id]);

  return ret;
}

void
mod_gl_utils_update_team_color_map (mod_gl_utils_team_color_map_t *
				    team_color_map,
				    lw6map_style_t * map_style)
{
  int i, j;
  Uint32 test;

  for (i = 0; i < LW6MAP_MAX_NB_TEAMS; ++i)
    {
      test =
	prepare_shaded_color_for_fighter (get_team_color (map_style, i),
					  MOD_GL_SHADES_FOR_FIGHTERS_SCALE);
      if (test !=
	  team_color_map->team_colors[i][MOD_GL_SHADES_FOR_FIGHTERS_SCALE])
	{
	  lw6sys_color_8_to_f (&(team_color_map->team_colors_f[i]),
			       map_style->team_colors[i]);
	  for (j = 0; j < MOD_GL_SHADES_FOR_FIGHTERS_SCALE + 1; ++j)
	    {
	      team_color_map->team_colors[i][j] =
		prepare_shaded_color_for_fighter (get_team_color
						  (map_style, i), j);
	    }
	}
    }
}
