
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>
#include <time.h>

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

void
mod_gl_utils_display_log (mod_gl_utils_context_t * context,
			  lw6gui_look_t * look, char **log_list)
{
  mod_gl_utils_draw_system_text_bottom_left (context, look, log_list);
}

void
mod_gl_display_log (void *context, lw6gui_look_t * look, char **log_list)
{
  mod_gl_utils_display_log ((mod_gl_utils_context_t *) context, look,
			    log_list);
}

void
mod_gl_utils_display_fps (mod_gl_utils_context_t * context,
			  lw6gui_look_t * look, int fps)
{
  char *list_fps[2];

  list_fps[0] = lw6sys_itoa (fps);
  list_fps[1] = NULL;

  if (list_fps[0])
    {
      mod_gl_utils_draw_system_text_top_right (context, look, list_fps);
      LW6SYS_FREE (list_fps[0]);
    }
}

void
mod_gl_display_fps (void *context, lw6gui_look_t * look, int fps)
{
  mod_gl_utils_display_fps ((mod_gl_utils_context_t *) context, look, fps);
}
