/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include "config.h"
#include "../../gfx.h"
#include "gl-utils.h"
#include "gl-utils-internal.h"

/*
 * Sets an offset so that time allways start at zero and is
 * library independant.
 */
void
mod_gl_utils_timer_init (mod_gl_utils_context_t * utils_context, int ticks)
{
  lw6sys_log (LW6SYS_LOG_INFO, _("init timer t0=%d"), ticks);

  utils_context->timer_data.ticks_offset = ticks - SDL_GetTicks ();
}

/*
 * Dummy wrapper arround SDL func.
 */
void
mod_gl_utils_delay (mod_gl_utils_context_t * utils_context, int ms)
{
  SDL_Delay (ms);
}

/*
  void
  mod_gl_delay (void *context, int ms)
  {
  mod_gl_utils_delay ((mod_gl_utils_context_t *) context, ms);
  }
*/

/*
 * Dummy wrapper arround SDL func.
 */
int
mod_gl_utils_get_ticks (mod_gl_utils_context_t * utils_context)
{
  return SDL_GetTicks () + utils_context->timer_data.ticks_offset;
}

/*
  int
  mod_gl_get_ticks (void *context)
  {
  return mod_gl_utils_get_ticks ((mod_gl_utils_context_t *) context);
  }
*/
