/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6GFX_MOD_GL_VIEW_FLAT_INTERNAL_H
#define LIQUIDWAR6GFX_MOD_GL_VIEW_FLAT_INTERNAL_H

#include <GL/gl.h>
#include <SDL/SDL.h>
#include <SDL/SDL_ttf.h>

#include "gl-flat.h"

typedef struct _mod_gl_view_flat_game_context_map_s
{
  int level_id;
  lw6map_level_t *level;
  mod_gl_utils_texture_array_t map_texture_array;
}
_mod_gl_view_flat_game_context_map_t;

typedef struct _mod_gl_view_flat_game_context_armies_s
{
  int game_state_id;
  lw6ker_game_state_t *game_state;
  mod_gl_utils_surface_array_t armies_surface_array;
  mod_gl_utils_texture_array_t armies_texture_arrays[LW6MAP_MAX_DEPTH];
}
_mod_gl_view_flat_game_context_armies_t;

typedef struct _mod_gl_view_flat_game_context_s
{
  _mod_gl_view_flat_game_context_map_t map;
  _mod_gl_view_flat_game_context_armies_t armies;
}
_mod_gl_view_flat_game_context_t;

typedef struct _mod_gl_view_flat_const_data_s
{
  float cursor_size;
  int tile_size_map;
  int tile_size_armies;
}
_mod_gl_view_flat_const_data_t;

typedef struct _mod_gl_view_flat_context_s
{
  _mod_gl_view_flat_game_context_t game_context;
  _mod_gl_view_flat_const_data_t const_data;
}
_mod_gl_view_flat_context_t;

/*
 * In data.c
 */
extern int _mod_gl_view_flat_load_data (mod_gl_utils_context_t *
					utils_context,
					_mod_gl_view_flat_context_t *
					flat_context);
extern void _mod_gl_view_flat_unload_data (mod_gl_utils_context_t *
					   utils_context,
					   _mod_gl_view_flat_context_t *
					   flat_context);

/*
 * In display.c
 */
extern void _mod_gl_view_flat_display_preview (mod_gl_utils_context_t *
					       utils_context,
					       _mod_gl_view_flat_context_t *
					       flat_context,
					       lw6gui_look_t * look,
					       lw6map_level_t * level);
extern void _mod_gl_view_flat_display_zones (mod_gl_utils_context_t *
					     utils_context,
					     _mod_gl_view_flat_context_t *
					     flat_context,
					     lw6gui_look_t * look,
					     lw6map_level_t * level,
					     lw6ker_map_struct_t *
					     map_struct);
extern void _mod_gl_view_flat_display_gradient (mod_gl_utils_context_t *
						utils_context,
						_mod_gl_view_flat_context_t *
						flat_context,
						lw6gui_look_t * look,
						lw6map_level_t * level,
						lw6ker_map_state_t *
						map_state, int team_id);
extern void _mod_gl_view_flat_display_game (mod_gl_utils_context_t *
					    utils_context,
					    _mod_gl_view_flat_context_t *
					    flat_context,
					    lw6gui_look_t * look,
					    lw6ker_game_state_t * game_state);

/*
 * In gamecontext.c
 */
extern int _mod_gl_view_flat_game_context_init (mod_gl_utils_context_t *
						utils_context,
						_mod_gl_view_flat_context_t
						* flat_context,
						_mod_gl_view_flat_game_context_t
						* game_context,
						lw6gui_look_t * look,
						lw6map_level_t * level,
						lw6ker_game_state_t *
						game_state);
extern int _mod_gl_view_flat_game_context_init_map (mod_gl_utils_context_t *
						    utils_context,
						    _mod_gl_view_flat_context_t
						    * flat_context,
						    _mod_gl_view_flat_game_context_map_t
						    * game_context_map,
						    lw6map_level_t * level);
extern int _mod_gl_view_flat_game_context_init_armies (mod_gl_utils_context_t
						       * utils_context,
						       _mod_gl_view_flat_context_t
						       * flat_context,
						       _mod_gl_view_flat_game_context_armies_t
						       * game_context_armies,
						       lw6gui_look_t * look,
						       lw6ker_game_state_t *
						       game_state);
extern void _mod_gl_view_flat_game_context_clear (mod_gl_utils_context_t *
						  utils_context,
						  _mod_gl_view_flat_context_t
						  * flat_context,
						  _mod_gl_view_flat_game_context_t
						  * game_context);
extern void _mod_gl_view_flat_game_context_clear_map (mod_gl_utils_context_t *
						      utils_context,
						      _mod_gl_view_flat_context_t
						      * flat_context,
						      _mod_gl_view_flat_game_context_map_t
						      * game_context_map);
extern void
_mod_gl_view_flat_game_context_clear_armies (mod_gl_utils_context_t *
					     utils_context,
					     _mod_gl_view_flat_context_t *
					     flat_context,
					     _mod_gl_view_flat_game_context_armies_t
					     * game_context_armies);
extern int _mod_gl_view_flat_game_context_update (mod_gl_utils_context_t *
						  utils_context,
						  _mod_gl_view_flat_context_t
						  * flat_context,
						  _mod_gl_view_flat_game_context_t
						  * game_context,
						  lw6gui_look_t * look,
						  lw6map_level_t * level,
						  lw6ker_game_state_t *
						  game_state);
extern int _mod_gl_view_flat_game_context_update_map (mod_gl_utils_context_t *
						      utils_context,
						      _mod_gl_view_flat_context_t
						      * flat_context,
						      _mod_gl_view_flat_game_context_map_t
						      * game_context_map,
						      lw6map_level_t * level);
extern int
_mod_gl_view_flat_game_context_update_armies (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_view_flat_context_t *
					      flat_context,
					      _mod_gl_view_flat_game_context_armies_t
					      * game_context_armies,
					      lw6gui_look_t * look,
					      lw6ker_game_state_t *
					      game_state);

/*
 * in pick.c
 */
extern void _mod_gl_view_flat_pick_map_coord (mod_gl_utils_context_t *
					      utils_context,
					      _mod_gl_view_flat_context_t *
					      flat_context,
					      lw6gui_look_t * look,
					      int *map_x,
					      int *map_y,
					      lw6ker_game_state_t *
					      game_state,
					      int screen_x, int screen_y);

/*
 * In setup.c
 */
extern _mod_gl_view_flat_context_t
  * _mod_gl_view_flat_init (mod_gl_utils_context_t * utils_context);
extern void _mod_gl_view_flat_quit (mod_gl_utils_context_t * utils_context,
				    _mod_gl_view_flat_context_t *
				    flat_context);

#endif
