/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <GL/glu.h>

#include "config.h"
#include "../../../gfx.h"
#include "gl-flat.h"
#include "gl-flat-internal.h"

#define MIN_SIDE 1.0f

void
_mod_gl_view_flat_pick_map_coord (mod_gl_utils_context_t * utils_context,
				  _mod_gl_view_flat_context_t *
				  flat_context,
				  lw6gui_look_t * look,
				  int *map_x,
				  int *map_y,
				  lw6ker_game_state_t * game_state,
				  int screen_x, int screen_y)
{
  float screen_x1, screen_y1, screen_x2, screen_y2;
  float screen_w, screen_h;
  lw6map_level_t *level = game_state->game_struct->level;

  mod_gl_utils_viewport_calc_map_area (utils_context, &screen_x1, &screen_y1,
				       &screen_x2, &screen_y2,
				       level->texture.shape.w,
				       level->texture.shape.h,
				       &(level->param));

  screen_w = screen_x2 - screen_x1;
  screen_h = screen_y2 - screen_y1;

  if (screen_w < MIN_SIDE)
    {
      screen_w = MIN_SIDE;
    }
  if (screen_h < MIN_SIDE)
    {
      screen_h = MIN_SIDE;
    }

  if (screen_x < screen_x1 || screen_x > screen_x2 || screen_y < screen_y1
      || screen_y > screen_y2)
    {
      // out of range
      (*map_x) = -1;
      (*map_y) = -1;
    }
  else
    {
      (*map_x) =
	((float) level->depth.shape.w) * (screen_x - screen_x1) / screen_w;
      (*map_y) =
	((float) level->depth.shape.h) * (screen_y - screen_y1) / screen_h;
    }
}

void
mod_gl_view_flat_pick_map_coord (mod_gl_utils_context_t *
				 utils_context,
				 void *flat_context,
				 lw6gui_look_t * look,
				 int *map_x,
				 int *map_y,
				 lw6ker_game_state_t * game_state,
				 int screen_x, int screen_y)
{
  _mod_gl_view_flat_pick_map_coord (utils_context,
				    (_mod_gl_view_flat_context_t *)
				    flat_context, look, map_x, map_y,
				    game_state, screen_x, screen_y);
}
