/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.


  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <string.h>

#include "config.h"
#include "../gfx.h"
#include "mod-gl.h"
#include "mod-gl-internal.h"


static void
display_background (void *gfx_context, lw6gui_look_t * look)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_background_display (&(mod_gl_context->utils_context),
				 mod_gl_context->background_backend, look);
    }
}

static void
display_hud (void *gfx_context, lw6gui_look_t * look,
	     lw6ker_game_state_t * game_state)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_hud_display (&(mod_gl_context->utils_context),
			  mod_gl_context->hud_backend, look, game_state);
    }
}

static int
poll_key (void *gfx_context, lw6gui_keypress_t * keypress)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_poll_key (&(mod_gl_context->utils_context),
				   keypress);
    }

  return ret;
}

static int
is_key_esc (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_esc (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_enter (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_enter (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_up (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_is_key_up (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_down (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_down (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_left (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_left (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
is_key_right (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_is_key_right (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
poll_quit (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_poll_quit (&(mod_gl_context->utils_context));
    }

  return ret;
}

static void
send_quit (void *gfx_context)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_send_quit (&(mod_gl_context->utils_context));
    }
}

static int
get_key_state (void *gfx_context, int keysym)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_get_key_state (&(mod_gl_context->utils_context), keysym);
    }

  return ret;
}

static int
poll_mouse_move (void *gfx_context, int *x, int *y)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_move (&(mod_gl_context->utils_context), x, y);
    }

  return ret;
}

static int
poll_mouse_button_left (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_button_left (&
					     (mod_gl_context->utils_context));
    }

  return ret;
}

static int
poll_mouse_button_right (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_button_right (&
					      (mod_gl_context->
					       utils_context));
    }

  return ret;
}

static int
poll_mouse_wheel_up (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_wheel_up (&(mod_gl_context->utils_context));
    }

  return ret;
}

static int
poll_mouse_wheel_down (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_mouse_wheel_down (&(mod_gl_context->utils_context));
    }

  return ret;
}

static void
get_mouse_state (void *gfx_context, int *x, int *y, int *button_left,
		 int *button_right)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_mouse_state (&(mod_gl_context->utils_context), x, y,
				    button_left, button_right);
    }
}

static int
poll_joystick_up (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_up (&(mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
poll_joystick_down (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_down (&(mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
poll_joystick_left (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_left (&(mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
poll_joystick_right (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_right (&
					  (mod_gl_context->utils_context), i);
    }

  return ret;
}

static int
poll_joystick_button_a (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_button_a (&
					     (mod_gl_context->
					      utils_context), i);
    }

  return ret;
}

static int
poll_joystick_button_b (void *gfx_context, int i)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_poll_joystick_button_b (&
					     (mod_gl_context->
					      utils_context), i);
    }

  return ret;
}

static void
get_joystick_state (void *gfx_context, int *x, int *y, int *button_a,
		    int *button_b, int i)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_get_joystick_state (&(mod_gl_context->utils_context), x, y,
				       button_a, button_b, i);
    }
}

static void
display_log (void *gfx_context, lw6gui_look_t * look, char **log_list)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_log (&(mod_gl_context->utils_context), look,
				log_list);
    }
}

static void
display_fps (void *gfx_context, lw6gui_look_t * look, int fps)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_display_fps (&(mod_gl_context->utils_context), look, fps);
    }
}

static void
display_map_preview (void *gfx_context, lw6gui_look_t * look,
		     lw6map_level_t * level)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_preview (&(mod_gl_context->utils_context),
				   mod_gl_context->view_backend, look, level);
    }
}

static void
display_map_zones (void *gfx_context, lw6gui_look_t * look,
		   lw6ker_game_struct_t * game_struct)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_zones (&(mod_gl_context->utils_context),
				 mod_gl_context->view_backend, look,
				 game_struct->level,
				 &(game_struct->map_struct));
    }
}

static void
display_map_gradient (void *gfx_context, lw6gui_look_t * look,
		      lw6ker_game_state_t * game_state, int team_id)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_gradient (&(mod_gl_context->utils_context),
				    mod_gl_context->view_backend, look,
				    game_state->game_struct->level,
				    &(game_state->map_state), team_id);
    }
}

static void
display_game (void *gfx_context, lw6gui_look_t * look,
	      lw6ker_game_state_t * game_state)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_display_game (&(mod_gl_context->utils_context),
				mod_gl_context->view_backend, look,
				game_state);
    }
}

static void
pick_map_coord (void *gfx_context, lw6gui_look_t * look, int *map_x,
		int *map_y, lw6ker_game_state_t * game_state, int screen_x,
		int screen_y)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_view_pick_map_coord (&(mod_gl_context->utils_context),
				  mod_gl_context->view_backend, look, map_x,
				  map_y, game_state, screen_x, screen_y);
    }
}

static void
display_menu (void *gfx_context, lw6gui_look_t * look, lw6gui_menu_t * menu)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_menu_display (&(mod_gl_context->utils_context),
			   mod_gl_context->menu_backend, look, menu);
    }
}

static void
pick_menuitem (void *gfx_context, lw6gui_look_t * look, int *position,
	       int *scroll, lw6gui_menu_t * menu, int x, int y)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      mod_gl_menu_pick_item (&(mod_gl_context->utils_context),
			     mod_gl_context->menu_backend, look, position,
			     scroll, menu, x, y);
    }
}

static int
warp_mouse_on_menuitem (void *gfx_context, lw6gui_look_t * look,
			lw6gui_menu_t * menu, int position)
{
  int ret = 0;

  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_set_backends (mod_gl_context, look);

      ret =
	mod_gl_menu_warp_mouse_on_menuitem (&(mod_gl_context->utils_context),
					    mod_gl_context->menu_backend,
					    look, menu, position);
    }

  return ret;
}

static void
prepare_buffer (void *gfx_context, lw6gui_look_t * look)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_prepare_buffer (&(mod_gl_context->utils_context), look);
    }
}

static void
swap_buffers (void *gfx_context)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_swap_buffers (&(mod_gl_context->utils_context));
    }
}

static void *
init (int argc, char *argv[], int width, int height, int fullscreen,
      void (*resize_callback) (int width, int height, int fullscreen),
      int ticks)
{
  _mod_gl_context_t *mod_gl_context =
    _mod_gl_init (argc, argv, width, height, fullscreen, resize_callback,
		  ticks);

  return (void *) mod_gl_context;
}

static int
set_video_mode (void *gfx_context, int width, int height,
		int fullscreen,
		void (*resize_callback) (int width,
					 int height, int fullscreen))
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_set_video_mode (&(mod_gl_context->utils_context), width,
				     height, fullscreen, resize_callback);
    }

  return ret;
}

static int
get_video_mode (void *gfx_context, int *width, int *height, int *fullscreen)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret =
	mod_gl_utils_get_video_mode (&(mod_gl_context->utils_context), width,
				     height, fullscreen);
    }

  return ret;
}

static void
quit (void *gfx_context)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      _mod_gl_quit (mod_gl_context);
    }
}

static void
delay (void *gfx_context, int ms)
{
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      mod_gl_utils_delay (&(mod_gl_context->utils_context), ms);
    }
}

static int
get_ticks (void *gfx_context)
{
  int ret = 0;
  _mod_gl_context_t *mod_gl_context = (_mod_gl_context_t *) gfx_context;

  if (mod_gl_context)
    {
      ret = mod_gl_utils_get_ticks (&(mod_gl_context->utils_context));
    }

  return ret;
}

lw6gfx_backend_t *
mod_gl_create_backend ()
{
  lw6gfx_backend_t *backend;

  backend = LW6SYS_CALLOC (sizeof (lw6gfx_backend_t));
  if (backend)
    {
      backend->display_background = display_background;
      backend->display_hud = display_hud;
      backend->poll_key = poll_key;
      backend->is_key_esc = is_key_esc;
      backend->is_key_enter = is_key_enter;
      backend->is_key_up = is_key_up;
      backend->is_key_down = is_key_down;
      backend->is_key_left = is_key_left;
      backend->is_key_right = is_key_right;
      backend->poll_quit = poll_quit;
      backend->send_quit = send_quit;
      backend->get_key_state = get_key_state;
      backend->poll_mouse_move = poll_mouse_move;
      backend->poll_mouse_button_left = poll_mouse_button_left;
      backend->poll_mouse_button_right = poll_mouse_button_right;
      backend->poll_mouse_wheel_up = poll_mouse_wheel_up;
      backend->poll_mouse_wheel_down = poll_mouse_wheel_down;
      backend->get_mouse_state = get_mouse_state;
      backend->poll_joystick_up = poll_joystick_up;
      backend->poll_joystick_down = poll_joystick_down;
      backend->poll_joystick_left = poll_joystick_left;
      backend->poll_joystick_right = poll_joystick_right;
      backend->poll_joystick_button_a = poll_joystick_button_a;
      backend->poll_joystick_button_b = poll_joystick_button_b;
      backend->get_joystick_state = get_joystick_state;
      backend->display_log = display_log;
      backend->display_fps = display_fps;
      backend->display_map_preview = display_map_preview;
      backend->display_map_zones = display_map_zones;
      backend->display_map_gradient = display_map_gradient;
      backend->display_game = display_game;
      backend->pick_map_coord = pick_map_coord;
      backend->display_menu = display_menu;
      backend->pick_menuitem = pick_menuitem;
      backend->warp_mouse_on_menuitem = warp_mouse_on_menuitem;
      backend->prepare_buffer = prepare_buffer;
      backend->swap_buffers = swap_buffers;
      backend->init = init;
      backend->set_video_mode = set_video_mode;
      backend->get_video_mode = get_video_mode;
      backend->quit = quit;
      backend->delay = delay;
      backend->get_ticks = get_ticks;
    }

  return backend;
}
