
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
  

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#ifndef LIQUIDWAR6LDR_H
#define LIQUIDWAR6LDR_H

#include "../sys/sys.h"
#include "../map/map.h"
#include "../cfg/cfg.h"
#include "../hlp/hlp.h"

typedef struct lw6ldr_entry_s
{
  char *title;
  char *absolute_path;
  char *relative_path;
  int has_subdirs;
}
lw6ldr_entry_t;

/*
 * In depth.c
 */
extern int lw6ldr_depth_read (lw6map_depth_t * depth, char *dirname,
			      lw6map_options_t * options,
			      lw6sys_wh_t * display_shape, float ratio,
			      float fighter_scale);

/*
 * In dir.c
 */
extern void lw6ldr_free_entry (lw6ldr_entry_t * entry);
extern lw6sys_list_t *lw6ldr_get_entries (char *map_path,
					  char *relative_path);

/*
 * In metadata.c
 */
extern int lw6ldr_metadata_read (lw6map_metadata_t * metadata, char *dirname);

/* ldr-options.c */
extern int lw6ldr_options_read (lw6map_options_t * param, char *dirname);
extern int lw6ldr_options_update (lw6map_options_t * options,
				  lw6sys_assoc_t * values);

/* ldr-param.c */
extern int lw6ldr_param_read (lw6map_param_t * param, char *dirname);
extern int lw6ldr_param_update (lw6map_param_t * param,
				lw6sys_assoc_t * values);

/* ldr-print.c */
extern void lw6ldr_print_example_options_xml (FILE * f);
extern void lw6ldr_print_example_style_xml (FILE * f);
extern int lw6ldr_print_examples (char *user_dir);

/* ldr-read.c */
extern lw6map_level_t *lw6ldr_read (char *dirname,
				    lw6sys_assoc_t * default_param,
				    lw6sys_assoc_t * forced_param,
				    lw6sys_wh_t * display_shape);
extern lw6map_level_t *lw6ldr_read_relative (char *map_path,
					     char *relative_path,
					     lw6sys_assoc_t * default_param,
					     lw6sys_assoc_t * forced_param,
					     lw6sys_wh_t * display_shape);

/* ldr-style.c */
extern int lw6ldr_style_read (lw6map_style_t * style, char *dirname);
extern int lw6ldr_style_update (lw6map_style_t * style,
				lw6sys_assoc_t * values);

/*
 * In test.c
 */
extern int lw6ldr_test ();

/*
 * In texture.c
 */
extern int lw6ldr_texture_read (lw6map_texture_t * texture, char *dirname,
				lw6map_style_t * style,
				lw6sys_wh_t * display_shape, float *ratio);

#endif
