
/*
  Liquid War 6 is a unique multiplayer wargame.
  Copyright (C)  2005, 2006, 2007, 2008  Christian Mauduit <ufoot@ufoot.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.

  Liquid War 6 homepage : http://www.gnu.org/software/liquidwar6/
  Contact author        : ufoot@ufoot.org
*/

#include <stdio.h>
#include <libguile.h>

#include "liquidwar6.h"

static void *
guile_main (void *data)
{
  char *script = NULL;

  SCM_DEVAL_P = 1;
  SCM_BACKTRACE_P = 1;
  SCM_RECORD_POSITIONS_P = 1;
  SCM_RESET_DEBUG_MODE;

  lw6sys_log (LW6SYS_LOG_INFO,
	      _("registering C types and functions for Guile"));
  lw6_register_smobs ();
  lw6_register_funcs ();

  script = lw6sys_get_script_file (lw6_global.argc, lw6_global.argv);
  if (script)
    {
      lw6sys_log (LW6SYS_LOG_INFO, _("loading \"%s\""), script);
      scm_c_primitive_load (script);
      LW6SYS_FREE (script);
    }

  scm_gc ();

  lw6_quit_global ();

  return NULL;
}

/**
 * lw6_main:
 * 
 * @argc: the argc parameter of the @main() function, that is, the number
 *   of command-line args.
 * @argv: the argv parameter of the @main() function, that is, an array
 *   containing pointers on command-line args.
 *
 * This function is directly called by @main(). This means by linking
 * against libliquidwar6 and calling it, you would have a program
 * that is almost exactly the "official" upstream liquidwar6 binary,
 * except you can tweak it and have all the power to call whatever
 * other functions you like, embed it. In short, everything the binary
 * does, you can do it in your own binarn, by linking against the
 * library and calling this function.
 *
 * Return value: 1 if success, zero if failure. Note that this
 *   is the "standard" C / liquidwar6 way to proceed, but your @main()
 *   function should return 0 if success, else an error code. Typical
 *   use is "return !lw6_main(argc, argv);".
 */
int
lw6_main (int argc, char *argv[])
{
  int ret = 0;
  char *log_file = NULL;
  int run_game = 1;

  ret = lw6_process_non_run_options (argc, argv, &run_game);
  if (run_game)
    {
      log_file = lw6cfg_unified_get_log_file (argc, argv);
      if (log_file)
	{
	  lw6sys_log_clear (log_file);
	  LW6SYS_FREE (log_file);
	}
      else
	{
	  lw6sys_log_sos (_("can't determine log file"));
	}

      lw6_print_hello (argc, argv);
      if (lw6_init_global (argc, argv))
	{
	  scm_with_guile (guile_main, NULL);
	}

      lw6_print_goodbye ();
    }
  else
    {
      lw6sys_clear_memory_bazooka ();
    }

  return ret;
}
